/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdDescriptor;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.parser.PmdCollector;
import hudson.plugins.pmd.util.AbortException;
import hudson.plugins.pmd.util.HealthAwarePublisher;
import hudson.plugins.pmd.util.HealthReportBuilder;
import hudson.plugins.pmd.util.model.JavaProject;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdPublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_PATTERN = "**/pmd.xml";
    public static final PmdDescriptor PMD_DESCRIPTOR = new PmdDescriptor();

    public PmdPublisher(String pattern, String threshold, String healthy, String unHealthy) {
        super(pattern, threshold, healthy, unHealthy);
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PmdProjectAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        try {
            logger.println("Collecting pmd analysis files...");
            JavaProject project = this.parseAllWorkspaceFiles(build, logger);
            PmdResult result = this.createResult(build, project);
            HealthReportBuilder healthReportBuilder = this.createHealthReporter(Messages.PMD_ResultAction_HealthReportSingleItem(), Messages.PMD_ResultAction_HealthReportMultipleItem((Object)"%d"));
            build.getActions().add(new PmdResultAction(build, result, healthReportBuilder));
            this.evaluateBuildResult(build, logger, project);
            return true;
        }
        catch (AbortException exception) {
            logger.println(exception.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private void evaluateBuildResult(AbstractBuild<?, ?> build, PrintStream logger, JavaProject project) {
        int warnings = project.getNumberOfAnnotations();
        if (warnings > 0) {
            logger.println("A total of " + warnings + " warnings have been found.");
            if (this.isThresholdEnabled() && warnings >= this.getMinimumAnnotations()) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            logger.println("No warnings have been found.");
        }
    }

    private JavaProject parseAllWorkspaceFiles(AbstractBuild<?, ?> build, PrintStream logger) throws IOException, InterruptedException {
        PmdCollector pmdCollector = new PmdCollector(logger, build.getTimestamp().getTimeInMillis(), StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN));
        return (JavaProject)build.getProject().getWorkspace().act((FilePath.FileCallable)pmdCollector);
    }

    private PmdResult createResult(AbstractBuild<?, ?> build, JavaProject project) {
        AbstractBuild previousBuild;
        PmdResultAction previousAction;
        Run previous = build.getPreviousBuild();
        PmdResult result = previous instanceof AbstractBuild ? ((previousAction = (PmdResultAction)(previousBuild = (AbstractBuild)previous).getAction(PmdResultAction.class)) == null ? new PmdResult(build, project) : new PmdResult(build, project, ((PmdResult)previousAction.getResult()).getProject(), ((PmdResult)previousAction.getResult()).getZeroWarningsHighScore())) : new PmdResult(build, project);
        return result;
    }

    public Descriptor<Publisher> getDescriptor() {
        return PMD_DESCRIPTOR;
    }
}

