/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.pmd.util.ChartBuilder;
import hudson.plugins.pmd.util.PriorityDetailFactory;
import hudson.plugins.pmd.util.SourceDetail;
import hudson.plugins.pmd.util.model.AnnotationContainer;
import hudson.plugins.pmd.util.model.AnnotationProvider;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.Priority;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Collection;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationsDetail
extends AnnotationContainer
implements ModelObject {
    private final AbstractBuild<?, ?> owner;
    private final String header;

    public AbstractAnnotationsDetail(AbstractBuild<?, ?> owner, Collection<FileAnnotation> annotations, String header) {
        this.owner = owner;
        this.header = header;
        this.addAnnotations(annotations);
    }

    protected String getTitle() {
        return this.header;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    protected final void createDetailGraph(StaplerRequest request, StaplerResponse response, AnnotationProvider detailObject, int upperBound) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        JFreeChart chart = ChartBuilder.createHighNormalLowChart((int)detailObject.getNumberOfAnnotations(Priority.HIGH), (int)detailObject.getNumberOfAnnotations(Priority.NORMAL), (int)detailObject.getNumberOfAnnotations(Priority.LOW), (int)upperBound);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)400, (int)20);
    }

    public String getLocalizedPriority(String priorityName) {
        return Priority.fromString((String)priorityName).getLongLocalizedString();
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        PriorityDetailFactory factory = new PriorityDetailFactory();
        if (factory.isPriority(link)) {
            return factory.create(link, this.owner, (AnnotationContainer)this, this.getTitle());
        }
        AbstractAnnotationsDetail detail = this.getDynamic(link);
        if (detail == null) {
            return new SourceDetail(this.getOwner(), this.getAnnotation(link));
        }
        return detail;
    }

    protected AbstractAnnotationsDetail getDynamic(String link) {
        return null;
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }
}

