/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdReporterDescriptor;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.parser.PmdCollector;
import hudson.plugins.pmd.util.HealthReportBuilder;
import hudson.plugins.pmd.util.model.JavaProject;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

public class PmdReporter
extends MavenReporter {
    public static final PmdReporterDescriptor PMD_SCANNER_DESCRIPTOR = new PmdReporterDescriptor();
    private static final String DEFAULT_PATTERN = "**/pmd.xml";
    private final String pattern;
    private final String threshold;
    private boolean thresholdEnabled;
    private int minimumAnnotations;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;

    public PmdReporter(String pattern, String threshold, String healthy, String unHealthy) {
        this.threshold = threshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.pattern = pattern;
        if (!StringUtils.isEmpty((String)threshold)) {
            try {
                this.minimumAnnotations = Integer.valueOf(threshold);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)healthy) && !StringUtils.isEmpty((String)unHealthy)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthy);
                this.unHealthyAnnotations = Integer.valueOf(unHealthy);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!"pmd".equals(mojo.getGoal())) {
            return true;
        }
        FilePath pomPath = new FilePath(pom.getBasedir());
        PmdCollector pmdCollector = new PmdCollector(listener.getLogger(), build.getTimestamp().getTimeInMillis(), StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN));
        final JavaProject project = (JavaProject)pomPath.act((FilePath.FileCallable)pmdCollector);
        build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){

            public Void call(MavenBuild build) throws IOException, InterruptedException {
                AbstractBuild previousBuild;
                PmdResultAction previousAction;
                Run previous = build.getPreviousBuild();
                PmdResult result = previous instanceof AbstractBuild ? ((previousAction = (PmdResultAction)(previousBuild = (AbstractBuild)previous).getAction(PmdResultAction.class)) == null ? new PmdResult((AbstractBuild<?, ?>)build, project) : new PmdResult((AbstractBuild<?, ?>)build, project, ((PmdResult)previousAction.getResult()).getProject(), ((PmdResult)previousAction.getResult()).getZeroWarningsHighScore())) : new PmdResult((AbstractBuild<?, ?>)build, project);
                HealthReportBuilder healthReportBuilder = new HealthReportBuilder(PmdReporter.this.thresholdEnabled, PmdReporter.this.minimumAnnotations, PmdReporter.this.healthyReportEnabled, PmdReporter.this.healthyAnnotations, PmdReporter.this.unHealthyAnnotations, Messages.PMD_ResultAction_HealthReportSingleItem(), Messages.PMD_ResultAction_HealthReportMultipleItem("%d"));
                build.getActions().add(new PmdResultAction((AbstractBuild<?, ?>)build, result, healthReportBuilder));
                build.registerAsProjectAction((MavenReporter)PmdReporter.this);
                return null;
            }
        });
        int warnings = project.getNumberOfAnnotations();
        if (warnings > 0) {
            listener.getLogger().println("A total of " + warnings + " warnings have been found.");
            if (this.thresholdEnabled && warnings >= this.minimumAnnotations) {
                build.setResult(Result.UNSTABLE);
            }
        } else {
            listener.getLogger().println("No warnings have been found.");
        }
        return true;
    }

    public Action getProjectAction(MavenModule module) {
        return new PmdProjectAction((AbstractProject<?, ?>)module);
    }

    public MavenReporterDescriptor getDescriptor() {
        return PMD_SCANNER_DESCRIPTOR;
    }
}

