/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.model.AbstractBuild;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.util.AbstractResultAction;
import hudson.plugins.pmd.util.HealthReportBuilder;
import hudson.plugins.pmd.util.model.Priority;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdResultAction
extends AbstractResultAction<PmdResult> {
    private static final long serialVersionUID = -5329651349674842873L;
    private static final String PMD_RESULT_URL = "pmdResult";

    public PmdResultAction(AbstractBuild<?, ?> owner, PmdResult result, HealthReportBuilder healthReportBuilder) {
        super(owner, healthReportBuilder, result);
    }

    @Override
    protected int getHealthCounter() {
        return ((PmdResult)this.getResult()).getNumberOfAnnotations();
    }

    public String getDisplayName() {
        return Messages.PMD_ProjectAction_Name();
    }

    @Override
    public String getIconUrl() {
        return "/plugin/pmd/icons/pmd-24x24.gif";
    }

    public String getUrlName() {
        return PMD_RESULT_URL;
    }

    public PmdResultAction getPreviousResultAction() {
        PmdResultAction previousBuild = this.getPreviousBuild();
        if (previousBuild == null) {
            throw new NoSuchElementException("There is no previous build for action " + this);
        }
        return previousBuild;
    }

    private PmdResultAction getPreviousBuild() {
        PmdResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (PmdResultAction)build.getAction(PmdResultAction.class)) == null);
        return action;
    }

    @Override
    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    @Override
    protected JFreeChart createChart(StaplerRequest request, StaplerResponse response) {
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, PMD_RESULT_URL, this.buildDataSet(useHealthBuilder), Messages.PMD_ResultAction_OneWarning(), Messages.PMD_ResultAction_MultipleWarnings("%d"));
    }

    private CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (PmdResultAction action = this; action != null; action = action.getPreviousBuild()) {
            List<Object> series;
            PmdResult current = (PmdResult)action.getResult();
            if (current == null) continue;
            if (useHealthBuilder && this.getHealthReportBuilder().isEnabled()) {
                series = this.getHealthReportBuilder().createSeries(current.getNumberOfAnnotations());
            } else {
                series = new ArrayList<Integer>();
                series.add(current.getNumberOfAnnotations(Priority.LOW));
                series.add(current.getNumberOfAnnotations(Priority.NORMAL));
                series.add(current.getNumberOfAnnotations(Priority.HIGH));
            }
            int level = 0;
            for (Integer n : series) {
                builder.add((Number)n, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }
}

