/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public final class MavenModuleDetector {
    public static String guessModuleName(String fileName) {
        String unixName = fileName.replace("\\", "/");
        String module = MavenModuleDetector.checkPrefix(unixName, "/src");
        if (StringUtils.isNotBlank((String)module)) {
            return module;
        }
        module = MavenModuleDetector.checkPrefix(unixName, "/target");
        if (StringUtils.isNotBlank((String)module)) {
            return module;
        }
        return "";
    }

    private static String checkPrefix(String file, String folder) {
        if (file.contains(folder)) {
            String module = StringUtils.substringBeforeLast((String)file, (String)folder);
            String projectName = MavenModuleDetector.parsePom(module);
            if (!StringUtils.isBlank((String)projectName)) {
                return projectName;
            }
            if (module.contains("/")) {
                module = StringUtils.substringAfterLast((String)module, (String)"/");
            }
            return module;
        }
        return "";
    }

    private static String parsePom(String fileName) {
        try {
            File pom = new File(fileName + "/pom.xml");
            if (pom.exists()) {
                Digester digester = new Digester();
                digester.setValidating(false);
                digester.setClassLoader(MavenModuleDetector.class.getClassLoader());
                digester.push((Object)new StringBuffer());
                digester.addCallMethod("project/name", "append", 0);
                StringBuffer result = (StringBuffer)digester.parse(pom);
                return result.toString();
            }
        }
        catch (IOException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return "";
    }

    private MavenModuleDetector() {
    }
}

