/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdDescriptor;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.PmdResultBuilder;
import hudson.plugins.pmd.parser.PmdParser;
import hudson.plugins.pmd.util.FilesParser;
import hudson.plugins.pmd.util.HealthAwarePublisher;
import hudson.plugins.pmd.util.HealthReportBuilder;
import hudson.plugins.pmd.util.ParserResult;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdPublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_PATTERN = "**/pmd.xml";
    public static final PmdDescriptor PMD_DESCRIPTOR = new PmdDescriptor();
    private final String pattern;

    @DataBoundConstructor
    public PmdPublisher(String pattern, String threshold, String healthy, String unHealthy, String height) {
        super(threshold, healthy, unHealthy, height, "PMD");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PmdProjectAction(project, this.getTrendHeight());
    }

    @Override
    public ParserResult perform(AbstractBuild<?, ?> build, PrintStream logger) throws InterruptedException, IOException {
        this.log(logger, "Collecting pmd analysis files...");
        FilesParser pmdCollector = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), new PmdParser(), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getProject().getWorkspace().act((FilePath.FileCallable)pmdCollector);
        PmdResult result = new PmdResultBuilder().build(build, project);
        HealthReportBuilder healthReportBuilder = this.createHealthReporter(Messages.PMD_ResultAction_HealthReportSingleItem(), Messages.PMD_ResultAction_HealthReportMultipleItem("%d"));
        build.getActions().add(new PmdResultAction(build, healthReportBuilder, result));
        return project;
    }

    public Descriptor<Publisher> getDescriptor() {
        return PMD_DESCRIPTOR;
    }
}

