/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.plugins.pmd.util.BuildResult;
import hudson.plugins.pmd.util.HealthAwarePublisher;
import hudson.plugins.pmd.util.HealthReportBuilder;
import hudson.plugins.pmd.util.ParserResult;
import hudson.plugins.pmd.util.PluginDescriptor;
import hudson.plugins.pmd.util.ResultAction;
import hudson.plugins.pmd.util.ToolTipProvider;
import hudson.plugins.pmd.util.model.Priority;
import hudson.tasks.Publisher;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultAction<T extends BuildResult>
implements StaplerProxy,
HealthReportingAction,
ToolTipProvider,
ResultAction<T> {
    private static final long serialVersionUID = -7201451538713818948L;
    private static final int WIDTH = 500;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    private HealthReportBuilder healthReportBuilder;
    private T result;

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, T result) {
        this(owner, healthReportBuilder);
        this.result = result;
    }

    public AbstractResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder) {
        this.owner = owner;
        this.healthReportBuilder = healthReportBuilder;
    }

    protected abstract PluginDescriptor getDescriptor();

    public String getUrlName() {
        return this.getDescriptor().getPluginResultUrlName();
    }

    @Override
    public final HealthReportBuilder getHealthReportBuilder() {
        if (this.healthReportBuilder == null) {
            this.healthReportBuilder = new HealthReportBuilder();
        }
        return this.healthReportBuilder;
    }

    public final HealthReport getBuildHealth() {
        AbstractProject project;
        DescribableList publishers;
        Publisher publisher;
        int numberOfAnnotations = this.getResult().getNumberOfAnnotations();
        AbstractProject object = this.owner.getProject();
        if (object instanceof AbstractProject && (publisher = (Publisher)(publishers = (project = object).getPublishersList()).get((Descriptor)this.getDescriptor())) instanceof HealthAwarePublisher) {
            HealthAwarePublisher healthAwarePublisher = (HealthAwarePublisher)publisher;
            numberOfAnnotations = 0;
            for (Priority priority : healthAwarePublisher.getPriorities()) {
                numberOfAnnotations += this.getResult().getNumberOfAnnotations(priority);
            }
        }
        return this.healthReportBuilder.computeHealth(numberOfAnnotations, this.getResult().getNumberOfAnnotations(), this.getResult().getNumberOfAnnotations(Priority.HIGH), this.getResult().getNumberOfAnnotations(Priority.NORMAL), this.getResult().getNumberOfAnnotations(Priority.LOW));
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final Object getTarget() {
        return this.getResult();
    }

    @Override
    public final T getResult() {
        return this.result;
    }

    @Override
    public final void setResult(T result) {
        this.result = result;
    }

    public String getIconFileName() {
        if (this.getResult().getNumberOfAnnotations() > 0) {
            return this.getDescriptor().getIconUrl();
        }
        return null;
    }

    @Override
    public final void doGraph(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)height);
    }

    @Override
    public final void doGraphMap(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createChart(request, response), (int)500, (int)height);
    }

    private JFreeChart createChart(StaplerRequest request, StaplerResponse response) {
        String parameter = request.getParameter("useHealthBuilder");
        boolean useHealthBuilder = Boolean.valueOf(StringUtils.defaultIfEmpty((String)parameter, (String)"true"));
        return this.getHealthReportBuilder().createGraph(useHealthBuilder, this.getDescriptor().getPluginResultUrlName(), this.buildDataSet(useHealthBuilder), this);
    }

    protected CategoryDataset buildDataSet(boolean useHealthBuilder) {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractResultAction<T> action = this; action != null; action = action.getPreviousBuild()) {
            List<Object> series;
            Object current = action.getResult();
            if (current == null) continue;
            if (useHealthBuilder && this.getHealthReportBuilder().isEnabled()) {
                series = this.getHealthReportBuilder().createSeries(current.getNumberOfAnnotations());
            } else {
                series = new ArrayList<Integer>();
                series.add(current.getNumberOfAnnotations(Priority.LOW));
                series.add(current.getNumberOfAnnotations(Priority.NORMAL));
                series.add(current.getNumberOfAnnotations(Priority.HIGH));
            }
            int level = 0;
            for (Integer n : series) {
                builder.add((Number)n, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getOwner()));
                ++level;
            }
        }
        return builder.build();
    }

    protected AbstractResultAction<T> getPreviousBuild() {
        AbstractResultAction action;
        AbstractBuild build = this.getOwner();
        do {
            if ((build = (AbstractBuild)build.getPreviousBuild()) != null) continue;
            return null;
        } while ((action = (AbstractResultAction)build.getAction(this.getClass())) == null);
        return action;
    }

    @Override
    public boolean hasPreviousResultAction() {
        return this.getPreviousBuild() != null;
    }

    protected ParserResult createAggregatedResult(Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        ParserResult project = this.createResult();
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            if (builds.isEmpty()) continue;
            this.addModule(project, builds);
        }
        return project;
    }

    protected ParserResult createResult() {
        return new ParserResult();
    }

    protected void addModule(ParserResult aggregatedResult, List<MavenBuild> builds) {
        AbstractResultAction action = (AbstractResultAction)builds.get(0).getAction(this.getClass());
        if (action != null) {
            aggregatedResult.addAnnotations(((BuildResult)action.getResult()).getAnnotations());
        }
    }
}

