/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import com.thoughtworks.xstream.XStream;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.pmd.util.model.AnnotationContainer;
import hudson.plugins.pmd.util.model.AnnotationProvider;
import hudson.plugins.pmd.util.model.AnnotationStream;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.Priority;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuildResult
implements ModelObject,
Serializable,
AnnotationProvider {
    private static final long serialVersionUID = 1110545450292087475L;
    protected static final XStream XSTREAM = new AnnotationStream();
    private final AbstractBuild<?, ?> owner;

    public BuildResult(AbstractBuild<?, ?> build) {
        this.owner = build;
    }

    protected final XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), this.getSerializationFileName()));
    }

    protected abstract String getSerializationFileName();

    public final boolean isCurrent() {
        return ((AbstractBuild)this.getOwner().getProject().getLastBuild()).number == this.getOwner().number;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public boolean hasAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public boolean hasAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public final boolean hasAnnotations() {
        return this.getContainer().hasAnnotations();
    }

    public boolean hasNoAnnotations() {
        return this.getContainer().hasNoAnnotations();
    }

    public boolean hasNoAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public boolean hasNoAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    public Collection<FileAnnotation> getAnnotations() {
        return this.getContainer().getAnnotations();
    }

    public FileAnnotation getAnnotation(long key) {
        return this.getContainer().getAnnotation(key);
    }

    public FileAnnotation getAnnotation(String key) {
        return this.getContainer().getAnnotation(key);
    }

    public Collection<FileAnnotation> getAnnotations(Priority priority) {
        return this.getContainer().getAnnotations(priority);
    }

    public Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getContainer().getAnnotations(priority);
    }

    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString((String)priority));
    }

    public abstract AnnotationContainer getContainer();
}

