/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.model.AbstractBuild;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.ResultSummary;
import hudson.plugins.pmd.parser.Bug;
import hudson.plugins.pmd.util.AnnotationsBuildResult;
import hudson.plugins.pmd.util.ParserResult;
import hudson.plugins.pmd.util.model.JavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdResult
extends AnnotationsBuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public PmdResult(AbstractBuild<?, ?> build, ParserResult result) {
        super(build, result);
    }

    public PmdResult(AbstractBuild<?, ?> build, ParserResult result, PmdResult previous) {
        super(build, result, (AnnotationsBuildResult)previous);
    }

    public String getSummary() {
        return ResultSummary.createSummary((PmdResult)this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage((PmdResult)this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            return message + "<li>" + Messages.PMD_ResultAction_NoWarningsSince((Object)this.getZeroWarningsSinceBuild()) + "</li>";
        }
        return message;
    }

    protected String getSerializationFileName() {
        return "pmd-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.PMD_ProjectAction_Name();
    }

    public JavaProject getPreviousResult() {
        PmdResultAction action = (PmdResultAction)this.getOwner().getAction(PmdResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((PmdResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    public boolean hasPreviousResult() {
        return ((PmdResultAction)this.getOwner().getAction(PmdResultAction.class)).hasPreviousResultAction();
    }

    static {
        XSTREAM.alias("bug", Bug.class);
    }
}

