/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.AbstractBuild;
import hudson.plugins.pmd.util.AnnotationDifferencer;
import hudson.plugins.pmd.util.BuildResult;
import hudson.plugins.pmd.util.ChartRenderer;
import hudson.plugins.pmd.util.DetailBuilder;
import hudson.plugins.pmd.util.ParserResult;
import hudson.plugins.pmd.util.model.AnnotationContainer;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.JavaProject;
import hudson.plugins.pmd.util.model.MavenModule;
import hudson.plugins.pmd.util.model.Priority;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationsBuildResult
extends BuildResult {
    private static final long serialVersionUID = -5183039263351537465L;
    private static final Logger LOGGER = Logger.getLogger(AnnotationsBuildResult.class.getName());
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Collection<FileAnnotation>> newWarnings;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Collection<FileAnnotation>> fixedWarnings;
    private int numberOfWarnings;
    private int numberOfNewWarnings;
    private int numberOfFixedWarnings;
    private int delta;
    private int low;
    private int normal;
    private int high;
    private int zeroWarningsSinceBuild;
    private long zeroWarningsSinceDate;
    private long zeroWarningsHighScore;
    @SuppressWarnings(value={"Se"})
    private List<String> errors;
    @SuppressWarnings(value={"Se"})
    private Map<String, MavenModule> emptyModules;
    private Set<String> modules;
    private int numberOfModules;

    public AnnotationsBuildResult(AbstractBuild<?, ?> build, ParserResult result) {
        super(build);
        this.initialize(result, new JavaProject());
    }

    public AnnotationsBuildResult(AbstractBuild<?, ?> build, ParserResult result, AnnotationsBuildResult previous) {
        super(build);
        JavaProject previousProject = previous.getProject();
        this.initialize(result, previousProject);
        if (result.hasNoAnnotations()) {
            if (previousProject.hasNoAnnotations()) {
                this.zeroWarningsSinceBuild = previous.getZeroWarningsSinceBuild();
                this.zeroWarningsSinceDate = previous.getZeroWarningsSinceDate();
            } else {
                this.zeroWarningsSinceBuild = build.getNumber();
                this.zeroWarningsSinceDate = build.getTimestamp().getTimeInMillis();
            }
            this.zeroWarningsHighScore = Math.max(previous.getZeroWarningsHighScore(), build.getTimestamp().getTimeInMillis() - this.zeroWarningsSinceDate);
        }
    }

    private void initialize(ParserResult result, AnnotationContainer previousProject) {
        this.numberOfWarnings = result.getNumberOfAnnotations();
        this.delta = result.getNumberOfAnnotations() - previousProject.getNumberOfAnnotations();
        Collection<FileAnnotation> allWarnings = result.getAnnotations();
        Set<FileAnnotation> warnings = AnnotationDifferencer.getNewWarnings(allWarnings, previousProject.getAnnotations());
        this.numberOfNewWarnings = warnings.size();
        this.newWarnings = new WeakReference<Set<FileAnnotation>>(warnings);
        warnings = AnnotationDifferencer.getFixedWarnings(allWarnings, previousProject.getAnnotations());
        this.numberOfFixedWarnings = warnings.size();
        this.fixedWarnings = new WeakReference<Set<FileAnnotation>>(warnings);
        this.high = result.getNumberOfAnnotations(Priority.HIGH);
        this.normal = result.getNumberOfAnnotations(Priority.NORMAL);
        this.low = result.getNumberOfAnnotations(Priority.LOW);
        this.numberOfModules = result.getNumberOfModules();
        this.modules = result.getModules();
        this.errors = new ArrayList<String>(result.getErrorMessages());
        this.serializeAnnotations(result.getAnnotations());
        JavaProject container = new JavaProject();
        container.addAnnotations(result.getAnnotations());
        this.project = new WeakReference<JavaProject>(container);
    }

    private void serializeAnnotations(Collection<FileAnnotation> annotations) {
        try {
            Collection<FileAnnotation> files = annotations;
            this.getDataFile().write((Object)files.toArray(new FileAnnotation[files.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Failed to serialize the annotations of the build.", exception);
        }
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public int getZeroWarningsSinceBuild() {
        return this.zeroWarningsSinceBuild;
    }

    public long getZeroWarningsSinceDate() {
        return this.zeroWarningsSinceDate;
    }

    public long getZeroWarningsHighScore() {
        return this.zeroWarningsHighScore;
    }

    @Override
    public int getNumberOfAnnotations() {
        return this.numberOfWarnings;
    }

    @Override
    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }

    public int getNumberOfFixedWarnings() {
        return this.numberOfFixedWarnings;
    }

    public int getNumberOfNewWarnings() {
        return this.numberOfNewWarnings;
    }

    public int getDelta() {
        return this.delta;
    }

    public synchronized JavaProject getProject() {
        if (this.project == null) {
            return this.loadResult();
        }
        JavaProject result = (JavaProject)this.project.get();
        if (result == null) {
            return this.loadResult();
        }
        return result;
    }

    private JavaProject loadResult() {
        JavaProject result;
        try {
            JavaProject newProject = new JavaProject();
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            LOGGER.log(Level.INFO, "Loaded data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new JavaProject();
        }
        this.project = new WeakReference<JavaProject>(result);
        return result;
    }

    public Collection<FileAnnotation> getNewWarnings() {
        if (this.newWarnings == null) {
            return this.loadNewWarnings();
        }
        Collection result = (Collection)this.newWarnings.get();
        if (result == null) {
            return this.loadNewWarnings();
        }
        return result;
    }

    private Collection<FileAnnotation> loadNewWarnings() {
        Collection<FileAnnotation> difference = this.getProject().getAnnotations();
        if (this.hasPreviousResult()) {
            difference = AnnotationDifferencer.getNewWarnings(difference, this.getPreviousResult().getAnnotations());
        }
        this.newWarnings = new WeakReference<Collection<FileAnnotation>>(difference);
        return difference;
    }

    public Collection<FileAnnotation> getFixedWarnings() {
        if (this.fixedWarnings == null) {
            return this.loadFixedWarnings();
        }
        Collection result = (Collection)this.fixedWarnings.get();
        if (result == null) {
            return this.loadFixedWarnings();
        }
        return result;
    }

    private Collection<FileAnnotation> loadFixedWarnings() {
        Collection<Object> difference = this.hasPreviousResult() ? AnnotationDifferencer.getFixedWarnings(this.getProject().getAnnotations(), this.getPreviousResult().getAnnotations()) : Collections.emptyList();
        this.fixedWarnings = new WeakReference<List<Collection<FileAnnotation>>>((List<Collection<FileAnnotation>>)difference);
        return difference;
    }

    protected abstract boolean hasPreviousResult();

    protected abstract JavaProject getPreviousResult();

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        return new DetailBuilder().createTrendDetails(link, this.getOwner(), this.getContainer(), this.getFixedWarnings(), this.getNewWarnings(), this.errors, this.getDisplayName());
    }

    public final void doStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        new ChartRenderer().doStatistics(request, response, this.getContainer());
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }

    @Override
    public AnnotationContainer getContainer() {
        return this.getProject();
    }
}

