/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import hudson.plugins.pmd.util.ChartBuilder;
import hudson.plugins.pmd.util.model.AnnotationContainer;
import hudson.plugins.pmd.util.model.AnnotationProvider;
import hudson.plugins.pmd.util.model.DefaultAnnotationContainer;
import hudson.plugins.pmd.util.model.JavaPackage;
import hudson.plugins.pmd.util.model.Priority;
import hudson.plugins.pmd.util.model.WorkspaceFile;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChartRenderer {
    public void doStatistics(StaplerRequest request, StaplerResponse response, AnnotationContainer container) throws IOException {
        String parameter = request.getParameter("object");
        if (parameter.startsWith("category.")) {
            this.renderPriorititesChart(request, response, (AnnotationProvider)container.getCategory(StringUtils.substringAfter((String)parameter, (String)"category.")), this.getUpperBound(container.getCategories()));
        } else if (parameter.startsWith("type.")) {
            this.renderPriorititesChart(request, response, (AnnotationProvider)container.getType(StringUtils.substringAfter((String)parameter, (String)"type.")), this.getUpperBound(container.getTypes()));
        } else if (parameter.startsWith("file.")) {
            WorkspaceFile annotations = container.getFile(Integer.valueOf(StringUtils.substringAfter((String)parameter, (String)"file.")).intValue());
            this.renderPriorititesChart(request, response, (AnnotationProvider)annotations, this.getUpperBound(container.getFiles()));
        } else if (parameter.startsWith("package.")) {
            JavaPackage annotations = container.getPackage(StringUtils.substringAfter((String)parameter, (String)"package."));
            this.renderPriorititesChart(request, response, (AnnotationProvider)annotations, this.getUpperBound(container.getPackages()));
        } else if (parameter.startsWith("module.")) {
            String moduleName = StringUtils.substringAfter((String)parameter, (String)"module.");
            Object annotations = container.containsModule(moduleName) ? container.getModule(moduleName) : new DefaultAnnotationContainer(moduleName);
            this.renderPriorititesChart(request, response, (AnnotationProvider)annotations, this.getUpperBound(container.getModules()));
        }
    }

    private int getUpperBound(Collection<? extends AnnotationContainer> containers) {
        int maximum = 0;
        for (AnnotationContainer annotationContainer : containers) {
            maximum = Math.max(maximum, annotationContainer.getNumberOfAnnotations());
        }
        return maximum;
    }

    private void renderPriorititesChart(StaplerRequest request, StaplerResponse response, AnnotationProvider detailObject, int upperBound) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        JFreeChart chart = ChartBuilder.createHighNormalLowChart((int)detailObject.getNumberOfAnnotations(Priority.HIGH), (int)detailObject.getNumberOfAnnotations(Priority.NORMAL), (int)detailObject.getNumberOfAnnotations(Priority.LOW), (int)upperBound);
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)400, (int)20);
    }
}

