/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import hudson.FilePath;
import hudson.plugins.pmd.util.AnnotationParser;
import hudson.plugins.pmd.util.FileFinder;
import hudson.plugins.pmd.util.MavenModuleDetector;
import hudson.plugins.pmd.util.Messages;
import hudson.plugins.pmd.util.model.JavaProject;
import hudson.plugins.pmd.util.model.MavenModule;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.exception.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesParser
implements FilePath.FileCallable<JavaProject> {
    private static final long serialVersionUID = -6415863872891783891L;
    private final transient PrintStream logger;
    private final String filePattern;
    private final AnnotationParser parser;

    public FilesParser(PrintStream listener, String filePattern, AnnotationParser parser) {
        this.logger = listener;
        this.filePattern = filePattern;
        this.parser = parser;
    }

    protected void log(String message) {
        if (this.logger != null) {
            this.logger.println("[" + this.parser.getName() + "] " + message);
        }
    }

    public JavaProject invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] fileNames = new FileFinder(this.filePattern).find(workspace);
        JavaProject project = new JavaProject();
        if (fileNames.length == 0) {
            project.setError(Messages.FilesParser_Error_NoFiles());
            return project;
        }
        try {
            MavenModuleDetector detector = new MavenModuleDetector();
            int duplicateModuleCounter = 1;
            for (String fileName : fileNames) {
                String message;
                File file = new File(workspace, fileName);
                String moduleName = detector.guessModuleName(file.getAbsolutePath());
                if (project.containsModule(moduleName)) {
                    moduleName = moduleName + "-" + duplicateModuleCounter++;
                }
                MavenModule module = new MavenModule(moduleName);
                if (!file.canRead()) {
                    message = Messages.FilesParser_Error_NoPermission((Object)file);
                    this.log(message);
                    module.setError(message);
                    continue;
                }
                if (new FilePath(file).length() <= 0L) {
                    message = Messages.FilesParser_Error_EmptyFile((Object)file);
                    this.log(message);
                    module.setError(message);
                    continue;
                }
                module = this.parseFile(workspace, file, module);
                project.addModule(module);
            }
        }
        catch (InterruptedException exception) {
            this.log("Parsing has been canceled.");
        }
        return project;
    }

    private MavenModule parseFile(File workspace, File file, MavenModule emptyModule) throws InterruptedException {
        Throwable exception = null;
        MavenModule module = emptyModule;
        try {
            FilePath filePath = new FilePath(file);
            module = this.parser.parse(filePath.read(), emptyModule.getName());
            this.log("Successfully parsed file " + file + " of module " + module.getName() + " with " + module.getNumberOfAnnotations() + " warnings.");
        }
        catch (IOException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e.getCause() == null ? e : e.getCause();
        }
        if (exception != null) {
            String errorMessage = Messages.FilesParser_Error_Exception((Object)file) + "\n\n" + ExceptionUtils.getStackTrace((Throwable)exception);
            this.log(errorMessage);
            module.setError(errorMessage);
        }
        return module;
    }
}

