/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.ResultSummary;
import hudson.plugins.pmd.parser.Bug;
import hudson.plugins.pmd.util.AnnotationDifferencer;
import hudson.plugins.pmd.util.ChartRenderer;
import hudson.plugins.pmd.util.ErrorDetail;
import hudson.plugins.pmd.util.FixedWarningsDetail;
import hudson.plugins.pmd.util.ModuleDetail;
import hudson.plugins.pmd.util.NewWarningsDetail;
import hudson.plugins.pmd.util.PackageDetail;
import hudson.plugins.pmd.util.PriorityDetailFactory;
import hudson.plugins.pmd.util.SourceDetail;
import hudson.plugins.pmd.util.model.AnnotationProvider;
import hudson.plugins.pmd.util.model.AnnotationStream;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.JavaPackage;
import hudson.plugins.pmd.util.model.JavaProject;
import hudson.plugins.pmd.util.model.MavenModule;
import hudson.plugins.pmd.util.model.Priority;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"PMD.TooManyFields"})
public class PmdResult
implements ModelObject,
Serializable,
AnnotationProvider {
    private static final long serialVersionUID = 2768250056765266658L;
    private static final Logger LOGGER = Logger.getLogger(PmdResult.class.getName());
    private static final XStream XSTREAM = new AnnotationStream();
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Set<FileAnnotation>> newWarnings;
    @SuppressWarnings(value={"Se"})
    private transient WeakReference<Set<FileAnnotation>> fixedWarnings;
    private final int numberOfWarnings;
    private final int numberOfNewWarnings;
    private final int numberOfFixedWarnings;
    private final int delta;
    private final int low;
    private final int normal;
    private final int high;
    private int zeroWarningsSinceBuild;
    private long zeroWarningsSinceDate;
    private long zeroWarningsHighScore;
    @SuppressWarnings(value={"Se"})
    private final List<String> errors;
    @SuppressWarnings(value={"Se"})
    private final AbstractBuild<?, ?> owner;
    @SuppressWarnings(value={"Se"})
    private final Map<String, MavenModule> emptyModules;
    private final int numberOfModules;

    public PmdResult(AbstractBuild<?, ?> build, JavaProject project) {
        this(build, project, new JavaProject(), 0L);
    }

    public PmdResult(AbstractBuild<?, ?> build, JavaProject project, JavaProject previousProject, long highScore) {
        this.owner = build;
        this.numberOfWarnings = project.getNumberOfAnnotations();
        this.project = new WeakReference<JavaProject>(project);
        this.delta = project.getNumberOfAnnotations() - previousProject.getNumberOfAnnotations();
        Collection<FileAnnotation> allWarnings = project.getAnnotations();
        Set<FileAnnotation> warnings = AnnotationDifferencer.getNewWarnings(allWarnings, previousProject.getAnnotations());
        this.numberOfNewWarnings = warnings.size();
        this.newWarnings = new WeakReference<Set<FileAnnotation>>(warnings);
        warnings = AnnotationDifferencer.getFixedWarnings(allWarnings, previousProject.getAnnotations());
        this.numberOfFixedWarnings = warnings.size();
        this.fixedWarnings = new WeakReference<Set<FileAnnotation>>(warnings);
        this.high = project.getNumberOfAnnotations(Priority.HIGH);
        this.normal = project.getNumberOfAnnotations(Priority.NORMAL);
        this.low = project.getNumberOfAnnotations(Priority.LOW);
        this.emptyModules = new HashMap<String, MavenModule>();
        for (MavenModule module : project.getModules()) {
            if (module.getNumberOfAnnotations() != 0) continue;
            this.emptyModules.put(module.getName(), module);
        }
        this.numberOfModules = project.getModules().size();
        this.errors = this.composeErrorMessage(project);
        if (this.numberOfWarnings == 0) {
            if (previousProject.getNumberOfAnnotations() != 0) {
                this.zeroWarningsSinceBuild = build.getNumber();
                this.zeroWarningsSinceDate = build.getTimestamp().getTimeInMillis();
            }
            this.zeroWarningsHighScore = Math.max(highScore, build.getTimestamp().getTimeInMillis() - this.zeroWarningsSinceDate);
        }
        try {
            Collection<FileAnnotation> files = project.getAnnotations();
            this.getDataFile().write((Object)files.toArray(new FileAnnotation[files.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to serialize the pmd result.", exception);
        }
    }

    private List<String> composeErrorMessage(JavaProject javaProject) {
        ArrayList<String> messages = new ArrayList<String>();
        if (javaProject.hasError()) {
            if (javaProject.getError() != null) {
                messages.add(javaProject.getError());
            }
            for (MavenModule module : javaProject.getModules()) {
                if (!module.hasError()) continue;
                messages.add(module.getError());
            }
        }
        return messages;
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage(this);
        if (this.numberOfWarnings == 0 && this.delta == 0) {
            return message + "<li>" + Messages.PMD_ResultAction_NoWarningsSince(this.zeroWarningsSinceBuild) + "</li>";
        }
        return message;
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.getOwner().getRootDir(), "pmd-warnings.xml"));
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public int getZeroWarningsSinceBuild() {
        return this.zeroWarningsSinceBuild;
    }

    public long getZeroWarningsSinceDate() {
        return this.zeroWarningsSinceDate;
    }

    public long getZeroWarningsHighScore() {
        return this.zeroWarningsHighScore;
    }

    public String getDisplayName() {
        return Messages.PMD_ProjectAction_Name();
    }

    @Override
    public int getNumberOfAnnotations() {
        return this.numberOfWarnings;
    }

    @Override
    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.high;
        }
        if (priority == Priority.NORMAL) {
            return this.normal;
        }
        return this.low;
    }

    public int getNumberOfFixedWarnings() {
        return this.numberOfFixedWarnings;
    }

    public int getNumberOfNewWarnings() {
        return this.numberOfNewWarnings;
    }

    public int getDelta() {
        return this.delta;
    }

    public JavaProject getProject() {
        JavaProject result;
        if (this.project == null) {
            this.loadResult();
        }
        if ((result = (JavaProject)this.project.get()) == null) {
            this.loadResult();
        }
        return (JavaProject)this.project.get();
    }

    public Set<FileAnnotation> getNewWarnings() {
        Set result;
        if (this.newWarnings == null) {
            this.loadPreviousResult();
        }
        if ((result = (Set)this.newWarnings.get()) == null) {
            this.loadPreviousResult();
        }
        return (Set)this.newWarnings.get();
    }

    public Set<FileAnnotation> getFixedWarnings() {
        Set result;
        if (this.fixedWarnings == null) {
            this.loadPreviousResult();
        }
        if ((result = (Set)this.fixedWarnings.get()) == null) {
            this.loadPreviousResult();
        }
        return (Set)this.fixedWarnings.get();
    }

    private void loadResult() {
        JavaProject result;
        try {
            JavaProject newProject = new JavaProject();
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            LOGGER.log(Level.INFO, "Loaded pmd data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new JavaProject();
        }
        this.project = new WeakReference<JavaProject>(result);
    }

    private void loadPreviousResult() {
        this.loadResult();
        this.newWarnings = this.hasPreviousResult() ? new WeakReference<Set<FileAnnotation>>(AnnotationDifferencer.getNewWarnings(this.getProject().getAnnotations(), this.getPreviousResult().getAnnotations())) : new WeakReference<HashSet<FileAnnotation>>(new HashSet<FileAnnotation>(this.getProject().getAnnotations()));
        this.fixedWarnings = this.hasPreviousResult() ? new WeakReference<Set<FileAnnotation>>(AnnotationDifferencer.getFixedWarnings(this.getProject().getAnnotations(), this.getPreviousResult().getAnnotations())) : new WeakReference<Set>(Collections.EMPTY_SET);
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        PriorityDetailFactory factory = new PriorityDetailFactory();
        if (factory.isPriority(link)) {
            return factory.create(link, this.owner, this.getProject(), Messages.PMD_Detail_header());
        }
        if ("fixed".equals(link)) {
            return new FixedWarningsDetail(this.getOwner(), this.getFixedWarnings(), Messages.PMD_FixedWarnings_Detail_header());
        }
        if ("new".equals(link)) {
            return new NewWarningsDetail(this.getOwner(), this.getNewWarnings(), Messages.PMD_NewWarnings_Detail_header());
        }
        if ("error".equals(link)) {
            return new ErrorDetail(this.getOwner(), "PMD", this.errors);
        }
        if (this.isSingleModuleProject()) {
            if (this.isSinglePackageProject()) {
                return new SourceDetail(this.getOwner(), this.getProject().getAnnotation(link));
            }
            return new PackageDetail(this.getOwner(), this.getModules().iterator().next().getPackage(link), Messages.PMD_Detail_header());
        }
        return new ModuleDetail(this.getOwner(), this.getModule(link), Messages.PMD_Detail_header());
    }

    private MavenModule getModule(String name) {
        MavenModule module = this.emptyModules.containsKey(name) ? this.emptyModules.get(name) : this.getProject().getModule(name);
        return module;
    }

    public Collection<JavaPackage> getPackages() {
        return this.getProject().getPackages();
    }

    public Collection<MavenModule> getModules() {
        ArrayList<MavenModule> modules = new ArrayList<MavenModule>();
        modules.addAll(this.emptyModules.values());
        for (MavenModule module : this.getProject().getModules()) {
            if (this.emptyModules.containsKey(module.getName())) continue;
            modules.add(module);
        }
        return modules;
    }

    public boolean isSingleModuleProject() {
        return this.getNumberOfModules() == 1;
    }

    public boolean isSinglePackageProject() {
        return this.isSingleModuleProject() && this.getProject().getPackages().size() == 1;
    }

    public int getPreviousNumberOfWarnings(String packageName) {
        JavaProject previousResult = this.getPreviousResult();
        if (previousResult != null) {
            return previousResult.getPackage(packageName).getNumberOfAnnotations();
        }
        return 0;
    }

    public JavaProject getPreviousResult() {
        PmdResultAction action = (PmdResultAction)this.getOwner().getAction(PmdResultAction.class);
        if (action.hasPreviousResultAction()) {
            return ((PmdResult)action.getPreviousResultAction().getResult()).getProject();
        }
        return null;
    }

    public boolean hasPreviousResult() {
        return ((PmdResultAction)this.getOwner().getAction(PmdResultAction.class)).hasPreviousResultAction();
    }

    public final void doModuleStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartRenderer.renderPriorititesChart(request, response, this.getModule(request.getParameter("module")), this.getProject().getAnnotationBound());
    }

    public final void doPackageStatistics(StaplerRequest request, StaplerResponse response) throws IOException {
        MavenModule module = this.getModules().iterator().next();
        ChartRenderer.renderPriorititesChart(request, response, module.getPackage(request.getParameter("package")), module.getAnnotationBound());
    }

    public String getToolTip(String name) {
        if (this.isSingleModuleProject()) {
            return this.getModules().iterator().next().getPackage(name).getToolTip();
        }
        return this.getModule(name).getToolTip();
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }

    @Override
    public FileAnnotation getAnnotation(long key) {
        return this.getProject().getAnnotation(key);
    }

    @Override
    public FileAnnotation getAnnotation(String key) {
        return this.getProject().getAnnotation(key);
    }

    @Override
    public Collection<FileAnnotation> getAnnotations(Priority priority) {
        return this.getProject().getAnnotations(priority);
    }

    @Override
    public Collection<FileAnnotation> getAnnotations(String priority) {
        return this.getProject().getAnnotations(priority);
    }

    @Override
    public boolean hasAnnotations(Priority priority) {
        return this.getProject().hasAnnotations(priority);
    }

    @Override
    public boolean hasAnnotations(String priority) {
        return this.getProject().hasAnnotations(priority);
    }

    @Override
    public final boolean hasAnnotations() {
        return this.getProject().hasAnnotations();
    }

    @Override
    public Collection<FileAnnotation> getAnnotations() {
        return this.getProject().getAnnotations();
    }

    @Override
    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString(priority));
    }

    static {
        XSTREAM.alias("bug", Bug.class);
    }
}

