/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.parser;

import hudson.plugins.pmd.util.model.AbstractAnnotation;
import hudson.plugins.pmd.util.model.Priority;
import org.apache.commons.lang.StringUtils;

public class Bug
extends AbstractAnnotation {
    private static final long serialVersionUID = 5171661552905752370L;
    private final String category;
    private final String type;
    private String tooltip = "";

    public Bug(Priority priority, String message, String category, String type, int start, int end) {
        super(priority, message, start, end);
        this.category = category;
        this.type = type;
    }

    public Bug(Priority priority, String message, String category, String type, int lineNumber) {
        this(priority, message, category, type, lineNumber, lineNumber);
    }

    public Bug(Priority priority, String message, String category, String type) {
        this(priority, message, category, type, 0, 0);
    }

    public Bug(Priority priority, String message, String category, String type, int start, int end, String tooltip) {
        this(priority, message, category, type, start, end);
        this.tooltip = tooltip;
    }

    public String getCategory() {
        return this.category;
    }

    public String getShortFileName() {
        return StringUtils.substringAfterLast((String)this.getFileName(), (String)"/");
    }

    public String getType() {
        return this.type;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = prime * result + (this.category == null ? 0 : this.category.hashCode());
        result = prime * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bug other = (Bug)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

