/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.maven.AggregatableAction;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.PmdResultBuilder;
import hudson.plugins.pmd.util.HealthReportBuilder;
import hudson.plugins.pmd.util.TrendReportSize;
import hudson.plugins.pmd.util.model.JavaProject;
import hudson.plugins.pmd.util.model.MavenModule;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenPmdResultAction
extends PmdResultAction
implements AggregatableAction,
MavenAggregatedReport {
    private static final long serialVersionUID = 1273798369273225973L;
    private final String height;

    public MavenPmdResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, String height) {
        super(owner, healthReportBuilder);
        this.height = height;
    }

    public MavenPmdResultAction(AbstractBuild<?, ?> owner, HealthReportBuilder healthReportBuilder, String height, PmdResult result) {
        super(owner, healthReportBuilder, result);
        this.height = height;
    }

    public MavenAggregatedReport createAggregatedAction(MavenModuleSetBuild build, Map<hudson.maven.MavenModule, List<MavenBuild>> moduleBuilds) {
        return new MavenPmdResultAction((AbstractBuild<?, ?>)build, this.getHealthReportBuilder(), this.height);
    }

    public Action getProjectAction(MavenModuleSet moduleSet) {
        return new PmdProjectAction((AbstractProject<?, ?>)moduleSet, new TrendReportSize(this.height).getHeight());
    }

    public Class<? extends AggregatableAction> getIndividualActionType() {
        return this.getClass();
    }

    public void update(Map<hudson.maven.MavenModule, List<MavenBuild>> moduleBuilds, MavenBuild newBuild) {
        JavaProject project = new JavaProject();
        for (List<MavenBuild> builds : moduleBuilds.values()) {
            if (builds.isEmpty()) continue;
            this.addModule(project, builds);
        }
        this.setResult(new PmdResultBuilder().build(this.getOwner(), project));
    }

    private void addModule(JavaProject project, List<MavenBuild> builds) {
        MavenBuild mavenBuild = builds.get(0);
        MavenPmdResultAction action = (MavenPmdResultAction)mavenBuild.getAction(this.getClass());
        if (action != null) {
            Collection<MavenModule> modules = ((PmdResult)action.getResult()).getProject().getModules();
            for (MavenModule mavenModule : modules) {
                project.addModule(mavenModule);
            }
        }
    }
}

