/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.parser;

import hudson.plugins.pmd.parser.Bug;
import hudson.plugins.pmd.parser.File;
import hudson.plugins.pmd.parser.Pmd;
import hudson.plugins.pmd.parser.PmdMessages;
import hudson.plugins.pmd.parser.Violation;
import hudson.plugins.pmd.util.AnnotationParser;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.MavenModule;
import hudson.plugins.pmd.util.model.Priority;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class PmdParser
implements AnnotationParser {
    public MavenModule parse(InputStream file, String moduleName) throws InvocationTargetException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(PmdParser.class.getClassLoader());
            String rootXPath = "pmd";
            digester.addObjectCreate(rootXPath, Pmd.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "pmd/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "pmd/file/violation";
            digester.addObjectCreate(bugXPath, Violation.class);
            digester.addSetProperties(bugXPath);
            digester.addCallMethod(bugXPath, "setMessage", 0);
            digester.addSetNext(bugXPath, "addViolation", Violation.class.getName());
            Pmd module = (Pmd)digester.parse(file);
            if (module == null) {
                throw new SAXException("Input stream is not a PMD file.");
            }
            return this.convert(module, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private MavenModule convert(Pmd collection, String moduleName) {
        MavenModule module = new MavenModule(moduleName);
        for (File file : collection.getFiles()) {
            for (Violation warning : file.getViolations()) {
                Priority priority = warning.getPriority() < 3 ? Priority.HIGH : (warning.getPriority() > 3 ? Priority.LOW : Priority.NORMAL);
                Bug bug = new Bug(priority, warning.getMessage() + ".", warning.getRuleset(), warning.getRule(), warning.getBeginline(), warning.getEndline(), PmdMessages.getInstance().getMessage(warning.getRuleset(), warning.getRule()));
                bug.setPackageName(warning.getPackage());
                bug.setModuleName(moduleName);
                bug.setFileName(file.getName());
                module.addAnnotation((FileAnnotation)bug);
            }
        }
        return module;
    }

    public String getName() {
        return "PMD";
    }
}

