/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util.model;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import hudson.plugins.pmd.util.Messages;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Priority {
    HIGH,
    NORMAL,
    LOW;


    public static Priority fromString(String priority) {
        return Priority.valueOf(StringUtils.upperCase((String)priority));
    }

    public String getLocalizedString() {
        if (this == HIGH) {
            return Messages.Priority_High();
        }
        if (this == LOW) {
            return Messages.Priority_Low();
        }
        return Messages.Priority_Normal();
    }

    public String getLongLocalizedString() {
        if (this == HIGH) {
            return Messages.HighPriority();
        }
        if (this == LOW) {
            return Messages.LowPriority();
        }
        return Messages.NormalPriority();
    }

    public static final class PriorityConverter
    extends AbstractSingleValueConverter {
        public boolean canConvert(Class type) {
            return type.equals(Priority.class);
        }

        public Object fromString(String str) {
            return Priority.valueOf(str);
        }
    }
}

