/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.parser;

import hudson.plugins.pmd.parser.Bug;
import hudson.plugins.pmd.parser.File;
import hudson.plugins.pmd.parser.Pmd;
import hudson.plugins.pmd.parser.PmdMessages;
import hudson.plugins.pmd.parser.Violation;
import hudson.plugins.pmd.util.AnnotationParser;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.Priority;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdParser
implements AnnotationParser {
    public Collection<FileAnnotation> parse(java.io.File file, String moduleName) throws InvocationTargetException {
        try {
            return this.parse((InputStream)new FileInputStream(file), moduleName);
        }
        catch (FileNotFoundException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws InvocationTargetException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(PmdParser.class.getClassLoader());
            String rootXPath = "pmd";
            digester.addObjectCreate(rootXPath, Pmd.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "pmd/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "pmd/file/violation";
            digester.addObjectCreate(bugXPath, Violation.class);
            digester.addSetProperties(bugXPath);
            digester.addCallMethod(bugXPath, "setMessage", 0);
            digester.addSetNext(bugXPath, "addViolation", Violation.class.getName());
            Pmd module = (Pmd)digester.parse(file);
            if (module == null) {
                throw new SAXException("Input stream is not a PMD file.");
            }
            return this.convert(module, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private Collection<FileAnnotation> convert(Pmd collection, String moduleName) {
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        for (File file : collection.getFiles()) {
            for (Violation warning : file.getViolations()) {
                Priority priority = warning.getPriority() < 3 ? Priority.HIGH : (warning.getPriority() > 3 ? Priority.LOW : Priority.NORMAL);
                Bug bug = new Bug(priority, warning.getMessage() + ".", warning.getRuleset(), warning.getRule(), warning.getBeginline(), warning.getEndline(), PmdMessages.getInstance().getMessage(warning.getRuleset(), warning.getRule()));
                bug.setPackageName(warning.getPackage());
                bug.setModuleName(moduleName);
                bug.setFileName(file.getName());
                annotations.add((FileAnnotation)bug);
            }
        }
        return annotations;
    }

    public String getName() {
        return "PMD";
    }
}

