/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.pmd.util.DefaultGraphConfigurationDetail;
import hudson.plugins.pmd.util.GraphConfiguration;
import hudson.plugins.pmd.util.PluginDescriptor;
import hudson.plugins.pmd.util.ResultAction;
import hudson.plugins.pmd.util.UserGraphConfigurationDetail;
import hudson.util.ChartUtil;
import java.io.IOException;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectAction<T extends ResultAction<?>>
implements Action {
    private static final long serialVersionUID = -8775531952208541253L;
    @SuppressWarnings(value={"Se"})
    private final AbstractProject<?, ?> project;
    private final Class<T> resultActionType;
    private final String iconUrl;
    private final String url;
    private final String resultUrl;

    public AbstractProjectAction(AbstractProject<?, ?> project, Class<T> resultActionType, PluginDescriptor plugin) {
        this.project = project;
        this.resultActionType = resultActionType;
        this.iconUrl = plugin.getIconUrl();
        this.url = plugin.getPluginName();
        this.resultUrl = plugin.getPluginResultUrlName();
    }

    public abstract String getTrendName();

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if ("configureDefaults".equals(link)) {
            return this.createDefaultConfiguration();
        }
        if ("configure".equals(link)) {
            return this.createUserConfiguration(request);
        }
        return null;
    }

    private Object createUserConfiguration(StaplerRequest request) {
        if (this.hasValidResults()) {
            return new UserGraphConfigurationDetail(this.getProject(), this.getUrlName(), request, this.getLastAction());
        }
        return new UserGraphConfigurationDetail(this.getProject(), this.getUrlName(), request);
    }

    private Object createDefaultConfiguration() {
        if (this.hasValidResults()) {
            return new DefaultGraphConfigurationDetail(this.getProject(), this.getUrlName(), this.getLastAction());
        }
        return new DefaultGraphConfigurationDetail(this.getProject(), this.getUrlName());
    }

    public final boolean hasValidResults() {
        ResultAction resultAction;
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null && (resultAction = (ResultAction)build.getAction(this.resultActionType)) != null) {
            return resultAction.hasPreviousResultAction();
        }
        return false;
    }

    public String getIconFileName() {
        if (this.getLastAction() != null) {
            return this.iconUrl;
        }
        return null;
    }

    public final String getUrlName() {
        return this.url;
    }

    public ResultAction<?> getLastAction() {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        if (lastBuild != null) {
            return (ResultAction)lastBuild.getAction(this.resultActionType);
        }
        return null;
    }

    public AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(this.resultActionType) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            this.doGraph(action, request, response);
        }
    }

    public void doTrendMap(StaplerRequest request, StaplerResponse response) throws IOException {
        ResultAction action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            this.doGraphMap(action, request, response);
        }
    }

    public boolean isTrendVisible(StaplerRequest request) {
        return this.hasValidResults() && new UserGraphConfigurationDetail(this.project, this.url, request).isVisible();
    }

    private void doGraph(ResultAction<?> action, StaplerRequest request, StaplerResponse response) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
        } else {
            GraphConfiguration configuration = this.createGraphConfiguration(request, action);
            if (configuration.isVisible()) {
                JFreeChart graph = configuration.createGraph(action.getHealthDescriptor(), action, this.url);
                ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)graph, (int)configuration.getWidth(), (int)configuration.getHeight());
            }
        }
    }

    private void doGraphMap(ResultAction<?> action, StaplerRequest request, StaplerResponse response) throws IOException {
        GraphConfiguration configuration = this.createGraphConfiguration(request, action);
        if (configuration.isVisible()) {
            JFreeChart graph = configuration.createGraph(action.getHealthDescriptor(), action, this.url);
            ChartUtil.generateClickableMap((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)graph, (int)configuration.getWidth(), (int)configuration.getHeight());
        }
    }

    public GraphConfiguration createGraphConfiguration(StaplerRequest request, ResultAction<?> action) {
        return new UserGraphConfigurationDetail(this.project, this.url, request, action);
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuild build = this.getLastFinishedBuild();
        if (build != null) {
            response.sendRedirect2(String.format("../%d/%s", build.getNumber(), this.resultUrl));
        }
    }
}

