/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.pmd.MavenPmdResultAction;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdPublisher;
import hudson.plugins.pmd.PmdReporterDescriptor;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultBuilder;
import hudson.plugins.pmd.parser.PmdParser;
import hudson.plugins.pmd.util.BuildResult;
import hudson.plugins.pmd.util.FilesParser;
import hudson.plugins.pmd.util.HealthAwareMavenReporter;
import hudson.plugins.pmd.util.ParserResult;
import hudson.plugins.pmd.util.PluginLogger;
import java.io.IOException;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = 2272875032054063496L;
    public static final PmdReporterDescriptor PMD_SCANNER_DESCRIPTOR = new PmdReporterDescriptor(PmdPublisher.PMD_DESCRIPTOR);
    private static final String PMD_XML_FILE = "pmd.xml";
    private String pattern;

    @DataBoundConstructor
    public PmdReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, "PMD");
    }

    @Override
    protected boolean acceptGoal(String goal) {
        return "pmd".equals(goal) || "site".equals(goal);
    }

    @Override
    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilesParser pmdCollector = new FilesParser(logger, PMD_XML_FILE, new PmdParser(this.getDefaultEncoding()), true, false);
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)pmdCollector);
    }

    @Override
    protected BuildResult persistResult(ParserResult project, MavenBuild build) {
        PmdResult result = new PmdResultBuilder().build((AbstractBuild<?, ?>)build, project, this.getDefaultEncoding());
        build.getActions().add(new MavenPmdResultAction((AbstractBuild<?, ?>)build, this, this.getDefaultEncoding(), result));
        build.registerAsProjectAction((MavenReporter)this);
        return result;
    }

    public Action getProjectAction(MavenModule module) {
        return new PmdProjectAction((AbstractProject<?, ?>)module);
    }

    @Override
    protected Class<? extends Action> getResultActionClass() {
        return MavenPmdResultAction.class;
    }

    public MavenReporterDescriptor getDescriptor() {
        return PMD_SCANNER_DESCRIPTOR;
    }
}

