/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.plugins.pmd.util.BoxRenderer;
import hudson.plugins.pmd.util.BuildResult;
import hudson.plugins.pmd.util.CategoryBuildResultGraph;
import hudson.plugins.pmd.util.CategoryUrlBuilder;
import hudson.plugins.pmd.util.Messages;
import hudson.plugins.pmd.util.ToolTipBuilder;
import hudson.plugins.pmd.util.ToolTipProvider;
import hudson.util.ColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewVersusFixedGraph
extends CategoryBuildResultGraph {
    @Override
    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        series.add(current.getNumberOfNewWarnings());
        series.add(current.getNumberOfFixedWarnings());
        return series;
    }

    @Override
    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createBlockChart(dataSet);
    }

    @Override
    protected Color[] getColors() {
        return new Color[]{ColorPalette.RED, ColorPalette.BLUE};
    }

    @Override
    @SuppressWarnings(value={"SIC"})
    protected CategoryItemRenderer createRenderer(String pluginName, ToolTipProvider toolTipProvider) {
        CategoryUrlBuilder url = new CategoryUrlBuilder(this.getRootUrl(), pluginName){

            protected String getDetailUrl(int row) {
                if (row == 1) {
                    return "fixed";
                }
                return "new";
            }
        };
        ToolTipBuilder toolTip = new ToolTipBuilder(toolTipProvider){

            protected String getShortDescription(int row) {
                if (row == 1) {
                    return Messages.Trend_Fixed();
                }
                return Messages.Trend_New();
            }
        };
        return new BoxRenderer(url, toolTip);
    }
}

