/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import hudson.plugins.pmd.util.BuildResult;
import hudson.plugins.pmd.util.BuildResultGraph;
import hudson.plugins.pmd.util.GraphConfiguration;
import hudson.plugins.pmd.util.ResultAction;
import hudson.plugins.pmd.util.ToolTipProvider;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.util.Calendar;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CategoryBuildResultGraph
extends BuildResultGraph {
    @Override
    public JFreeChart create(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, String pluginName) {
        JFreeChart chart = this.createChart(configuration, resultAction);
        CategoryItemRenderer renderer = this.createRenderer(pluginName, resultAction.getToolTipProvider());
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer(renderer);
        this.setColors(chart, this.getColors());
        return chart;
    }

    protected JFreeChart createChart(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction) {
        Calendar oldBuildTime;
        DataSetBuilder builder = new DataSetBuilder();
        ResultAction<? extends BuildResult> action = resultAction;
        int buildCount = 0;
        Calendar buildTime = action.getBuild().getTimestamp();
        do {
            BuildResult current = action.getResult();
            List<Integer> series = this.computeSeries(current);
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)Integer.valueOf(level), (Comparable)new ChartUtil.NumberOnlyBuildLabel(action.getBuild()));
                ++level;
            }
            if (!action.hasPreviousResultAction()) break;
            action = action.getPreviousResultAction();
        } while ((!configuration.isBuildCountDefined() || ++buildCount < configuration.getBuildCount()) && (!configuration.isDayCountDefined() || this.computeDayDelta(buildTime, oldBuildTime = action.getBuild().getTimestamp()) < (long)configuration.getDayCount()));
        return this.createChart(builder.build());
    }

    protected abstract List<Integer> computeSeries(BuildResult var1);

    protected abstract JFreeChart createChart(CategoryDataset var1);

    protected abstract CategoryItemRenderer createRenderer(String var1, ToolTipProvider var2);

    protected abstract Color[] getColors();

    protected void setColors(JFreeChart chart, Color[] colors) {
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        int series = 0;
        for (Color color : colors) {
            renderer.setSeriesPaint(series, (Paint)color);
            ++series;
        }
    }

    protected void setCategoryPlotProperties(CategoryPlot plot) {
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.setPlotProperties((Plot)plot);
    }

    public JFreeChart createAreaChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        this.setCategoryPlotProperties(chart.getCategoryPlot());
        chart.getCategoryPlot().getDomainAxis().setCategoryMargin(0.0);
        return chart;
    }

    public JFreeChart createBlockChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, (String)"count", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        this.setCategoryPlotProperties(chart.getCategoryPlot());
        return chart;
    }
}

