/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.pmd.util.AbortException;
import hudson.plugins.pmd.util.BuildResult;
import hudson.plugins.pmd.util.BuildResultEvaluator;
import hudson.plugins.pmd.util.HealthDescriptor;
import hudson.plugins.pmd.util.Messages;
import hudson.plugins.pmd.util.ParserResult;
import hudson.plugins.pmd.util.PluginLogger;
import hudson.plugins.pmd.util.TrendReportHeightValidator;
import hudson.plugins.pmd.util.model.DefaultAnnotationContainer;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.Priority;
import hudson.plugins.pmd.util.model.WorkspaceFile;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwareMavenReporter
extends MavenReporter
implements HealthDescriptor {
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private static final long serialVersionUID = 3003791883748835331L;
    private final String threshold;
    private boolean thresholdEnabled;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private int minimumAnnotations;
    private final String newThreshold;
    private final String healthy;
    private final String unHealthy;
    private int healthyAnnotations;
    private int unHealthyAnnotations;
    private boolean healthyReportEnabled;
    private final String height;
    private final String pluginName;
    private String thresholdLimit;
    private String defaultEncoding;

    public HealthAwareMavenReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String height, String thresholdLimit, String pluginName) {
        this.threshold = threshold;
        this.newThreshold = newThreshold;
        this.failureThreshold = failureThreshold;
        this.newFailureThreshold = newFailureThreshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.height = height;
        this.thresholdLimit = thresholdLimit;
        this.pluginName = "[" + pluginName + "] ";
        this.validateThreshold(threshold);
        this.validateHealthiness(healthy, unHealthy);
    }

    private void validateHealthiness(String healthyParameter, String unHealthyParameter) {
        if (!StringUtils.isEmpty((String)healthyParameter) && !StringUtils.isEmpty((String)unHealthyParameter)) {
            try {
                this.healthyAnnotations = Integer.valueOf(healthyParameter);
                this.unHealthyAnnotations = Integer.valueOf(unHealthyParameter);
                if (this.healthyAnnotations >= 0 && this.unHealthyAnnotations > this.healthyAnnotations) {
                    this.healthyReportEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void validateThreshold(String thresholdParameter) {
        if (!StringUtils.isEmpty((String)thresholdParameter)) {
            try {
                this.minimumAnnotations = Integer.valueOf(thresholdParameter);
                if (this.minimumAnnotations >= 0) {
                    this.thresholdEnabled = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @SuppressWarnings(value={"Se"})
    private Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        return this;
    }

    public final boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!this.acceptGoal(mojo.getGoal())) {
            return true;
        }
        PluginLogger logger = new PluginLogger(listener.getLogger(), this.pluginName);
        if (this.hasResultAction(build).booleanValue()) {
            logger.log("Scipping maven reporter: there is already a result available.");
            return true;
        }
        try {
            Result buildResult;
            this.defaultEncoding = pom.getProperties().getProperty("project.build.sourceEncoding");
            ParserResult result = this.perform(build, pom, mojo, logger);
            if (this.defaultEncoding == null) {
                logger.log(Messages.Reporter_Error_NoEncoding((Object)Charset.defaultCharset().displayName()));
                result.addErrorMessage(pom.getName(), Messages.Reporter_Error_NoEncoding((Object)Charset.defaultCharset().displayName()));
            }
            ParserResult newResult = (ParserResult)build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
            if (build.getRootDir().isRemote()) {
                this.copyFilesToMaster(logger, build.getProjectRootDir(), build.getRootDir(), result.getAnnotations());
            }
            if ((buildResult = new BuildResultEvaluator().evaluateBuildResult(logger, this.getMinimumPriority(), result, this.getThreshold(), this.getFailureThreshold(), newResult, this.getNewThreshold(), this.getNewFailureThreshold())) != Result.SUCCESS) {
                build.setResult(buildResult);
            }
        }
        catch (AbortException exception) {
            logger.log((Throwable)exception);
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    private void copyFilesToMaster(PluginLogger logger, FilePath slaveRoot, FilePath masterRoot, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        FilePath directory = new FilePath(masterRoot, "workspace-files");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            FilePath masterFile = new FilePath(directory, file.getTempName());
            if (masterFile.exists()) continue;
            try {
                new FilePath((VirtualChannel)((Channel)null), file.getName()).copyTo(masterFile);
            }
            catch (IOException exception) {
                String message = "Can't copy source file: source=" + file.getName() + ", destination=" + masterFile.getName();
                logger.log(message);
                logger.printStackTrace((Throwable)exception);
            }
        }
    }

    protected abstract boolean acceptGoal(String var1);

    protected abstract ParserResult perform(MavenBuildProxy var1, MavenProject var2, MojoInfo var3, PluginLogger var4) throws InterruptedException, IOException;

    protected abstract BuildResult persistResult(ParserResult var1, MavenBuild var2);

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private Boolean hasResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract Class<? extends Action> getResultActionClass();

    protected FilePath getTargetPath(MavenProject pom) {
        return new FilePath(new FilePath(pom.getBasedir()), "target");
    }

    public boolean isThresholdEnabled() {
        return this.thresholdEnabled;
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getNewThreshold() {
        return this.newThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    public int getMinimumAnnotations() {
        return this.minimumAnnotations;
    }

    public boolean isHealthyReportEnabled() {
        return this.healthyReportEnabled;
    }

    public String getHealthy() {
        return this.healthy;
    }

    public int getHealthyAnnotations() {
        return this.healthyAnnotations;
    }

    public String getUnHealthy() {
        return this.unHealthy;
    }

    public int getUnHealthyAnnotations() {
        return this.unHealthyAnnotations;
    }

    public String getHeight() {
        return this.height;
    }

    public int getTrendHeight() {
        return TrendReportHeightValidator.defaultHeight((String)this.height);
    }

    public Priority getMinimumPriority() {
        return Priority.valueOf((String)StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }
}

