/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.pmd.util.AbortException;
import hudson.plugins.pmd.util.BuildResult;
import hudson.plugins.pmd.util.HealthDescriptor;
import hudson.plugins.pmd.util.Messages;
import hudson.plugins.pmd.util.ParserResult;
import hudson.plugins.pmd.util.PluginLogger;
import hudson.plugins.pmd.util.model.DefaultAnnotationContainer;
import hudson.plugins.pmd.util.model.FileAnnotation;
import hudson.plugins.pmd.util.model.Priority;
import hudson.plugins.pmd.util.model.WorkspaceFile;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HealthAwareMavenReporter
extends MavenReporter
implements HealthDescriptor {
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private static final long serialVersionUID = 3003791883748835331L;
    private final String threshold;
    private final String failureThreshold;
    private final String newFailureThreshold;
    private final String newThreshold;
    private final String healthy;
    private final String unHealthy;
    private final String pluginName;
    private String thresholdLimit;
    private String defaultEncoding;
    @Deprecated
    private transient boolean thresholdEnabled;
    @Deprecated
    private transient int minimumAnnotations;
    @Deprecated
    private transient int healthyAnnotations;
    @Deprecated
    private transient int unHealthyAnnotations;
    @Deprecated
    private transient boolean healthyReportEnabled;
    @Deprecated
    private transient String height;

    public HealthAwareMavenReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String pluginName) {
        this.threshold = threshold;
        this.newThreshold = newThreshold;
        this.failureThreshold = failureThreshold;
        this.newFailureThreshold = newFailureThreshold;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = thresholdLimit;
        this.pluginName = "[" + pluginName + "] ";
    }

    @SuppressWarnings(value={"Se"})
    private Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        return this;
    }

    public final boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!this.acceptGoal(mojo.getGoal())) {
            return true;
        }
        if (this.canContinue(this.getCurrentResult(build))) {
            PluginLogger logger = new PluginLogger(listener.getLogger(), this.pluginName);
            if (this.hasResultAction(build).booleanValue()) {
                logger.log("Scipping maven reporter: there is already a result available.");
                return true;
            }
            try {
                this.defaultEncoding = pom.getProperties().getProperty("project.build.sourceEncoding");
                final ParserResult result = this.perform(build, pom, mojo, logger);
                if (this.defaultEncoding == null) {
                    logger.log(Messages.Reporter_Error_NoEncoding(Charset.defaultCharset().displayName()));
                    result.addErrorMessage(pom.getName(), Messages.Reporter_Error_NoEncoding(Charset.defaultCharset().displayName()));
                }
                build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){

                    public Void call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                        HealthAwareMavenReporter.this.persistResult(result, mavenBuild);
                        return null;
                    }
                });
                if (build.getRootDir().isRemote()) {
                    this.copyFilesToMaster(logger, build.getProjectRootDir(), build.getRootDir(), result.getAnnotations());
                }
            }
            catch (AbortException exception) {
                logger.log(exception);
                build.setResult(Result.FAILURE);
                return false;
            }
        }
        return true;
    }

    private Result getCurrentResult(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Result)build.execute((MavenBuildProxy.BuildCallable)new BuildResultCallable());
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    private void copyFilesToMaster(PluginLogger logger, FilePath slaveRoot, FilePath masterRoot, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        FilePath directory = new FilePath(masterRoot, "workspace-files");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            FilePath masterFile = new FilePath(directory, file.getTempName());
            if (masterFile.exists()) continue;
            try {
                new FilePath((VirtualChannel)((Channel)null), file.getName()).copyTo(masterFile);
            }
            catch (IOException exception) {
                String message = "Can't copy source file: source=" + file.getName() + ", destination=" + masterFile.getName();
                logger.log(message);
                logger.printStackTrace(exception);
            }
        }
    }

    protected abstract boolean acceptGoal(String var1);

    protected abstract ParserResult perform(MavenBuildProxy var1, MavenProject var2, MojoInfo var3, PluginLogger var4) throws InterruptedException, IOException;

    protected abstract BuildResult persistResult(ParserResult var1, MavenBuild var2);

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private Boolean hasResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Boolean, IOException>(){

            public Boolean call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                return mavenBuild.getAction(HealthAwareMavenReporter.this.getResultActionClass()) != null;
            }
        });
    }

    protected abstract Class<? extends Action> getResultActionClass();

    protected FilePath getTargetPath(MavenProject pom) {
        return new FilePath(new FilePath(pom.getBasedir()), "target");
    }

    @Override
    public String getThreshold() {
        return this.threshold;
    }

    @Override
    public String getNewThreshold() {
        return this.newThreshold;
    }

    @Override
    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    @Override
    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    @Override
    public String getHealthy() {
        return this.healthy;
    }

    @Override
    public String getUnHealthy() {
        return this.unHealthy;
    }

    @Override
    public Priority getMinimumPriority() {
        return Priority.valueOf(StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BuildResultCallable
    implements MavenBuildProxy.BuildCallable<Result, IOException> {
        private static final long serialVersionUID = -270795641776014760L;

        private BuildResultCallable() {
        }

        public Result call(MavenBuild mavenBuild) throws IOException, InterruptedException {
            return mavenBuild.getResult();
        }
    }
}

