/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;

public final class PmdMessages {
    private static final PmdMessages INSTANCE = new PmdMessages();
    private final Map<String, RuleSet> rules = new HashMap();

    public static PmdMessages getInstance() {
        return INSTANCE;
    }

    private PmdMessages() {
    }

    public void initialize() {
        try {
            Iterator ruleSets;
            Iterator iterator = ruleSets = new RuleSetFactory().getRegisteredRuleSets();
            while (iterator.hasNext()) {
                RuleSet ruleSet = (RuleSet)iterator.next();
                this.rules.put(ruleSet.getName(), ruleSet);
            }
        }
        catch (RuleSetNotFoundException exception) {
            Logger.getLogger(PmdMessages.class.getName()).log(Level.SEVERE, "Installation problem: can't access PMD messages.");
        }
    }

    public String getMessage(String ruleSetName, String ruleName) {
        RuleSet ruleSet;
        Rule rule;
        if (this.rules.containsKey(ruleSetName) && (rule = (ruleSet = (RuleSet)this.rules.get(ruleSetName)).getRuleByName(ruleName)) != null) {
            return this.createMessage(rule);
        }
        return "";
    }

    private String createMessage(Rule rule) {
        List examples = rule.getExamples();
        if (!examples.isEmpty()) {
            return rule.getDescription() + "<pre>" + (String)examples.get(0) + "</pre>";
        }
        return rule.getDescription();
    }
}

