/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import com.thoughtworks.xstream.XStream;
import hudson.model.AbstractBuild;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.pmd.Messages;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.ResultSummary;
import hudson.plugins.pmd.parser.Bug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdResult
extends BuildResult {
    private static final long serialVersionUID = 2768250056765266658L;

    public PmdResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        super(build, defaultEncoding, result);
    }

    public PmdResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, PmdResult previous) {
        super(build, defaultEncoding, result, (BuildResult)previous);
    }

    protected void configure(XStream xstream) {
        xstream.alias("bug", Bug.class);
    }

    public String getSummary() {
        return ResultSummary.createSummary(this);
    }

    public String getDetails() {
        String message = ResultSummary.createDeltaMessage(this);
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            message = message + "<li>" + Messages.PMD_ResultAction_NoWarningsSince(this.getZeroWarningsSinceBuild()) + "</li>";
            message = message + this.createHighScoreMessage();
        }
        return message;
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = PmdResult.getDays((long)this.getZeroWarningsHighScore());
            if (days == 1L) {
                return "<li>" + Messages.PMD_ResultAction_OneHighScore() + "</li>";
            }
            return "<li>" + Messages.PMD_ResultAction_MultipleHighScore(days) + "</li>";
        }
        long days = PmdResult.getDays((long)this.getHighScoreGap());
        if (days == 1L) {
            return "<li>" + Messages.PMD_ResultAction_OneNoHighScore() + "</li>";
        }
        return "<li>" + Messages.PMD_ResultAction_MultipleNoHighScore(days) + "</li>";
    }

    protected String getSerializationFileName() {
        return "pmd-warnings.xml";
    }

    public String getDisplayName() {
        return Messages.PMD_ProjectAction_Name();
    }

    protected Class<? extends ResultAction<? extends BuildResult>> getResultActionType() {
        return PmdResultAction.class;
    }
}

