/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd.parser;

import hudson.plugins.analysis.core.AbstractAnnotationParser;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.pmd.parser.Bug;
import hudson.plugins.pmd.parser.File;
import hudson.plugins.pmd.parser.Pmd;
import hudson.plugins.pmd.parser.Violation;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdParser
extends AbstractAnnotationParser {
    private static final long serialVersionUID = 6507147028628714706L;
    private static final int PMD_PRIORITY_MAPPED_TO_HIGH_PRIORITY = 3;
    private static final int PMD_PRIORITY_MAPPED_TO_LOW_PRIORITY = 4;

    public PmdParser() {
        super("");
    }

    public PmdParser(String defaultEncoding) {
        super(defaultEncoding);
    }

    public Collection<FileAnnotation> parse(InputStream file, String moduleName) throws InvocationTargetException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(PmdParser.class.getClassLoader());
            String rootXPath = "pmd";
            digester.addObjectCreate(rootXPath, Pmd.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "pmd/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "pmd/file/violation";
            digester.addObjectCreate(bugXPath, Violation.class);
            digester.addSetProperties(bugXPath);
            digester.addCallMethod(bugXPath, "setMessage", 0);
            digester.addSetNext(bugXPath, "addViolation", Violation.class.getName());
            Pmd module = (Pmd)digester.parse(file);
            if (module == null) {
                throw new SAXException("Input stream is not a PMD file.");
            }
            return this.convert(module, moduleName);
        }
        catch (IOException exception) {
            throw new InvocationTargetException(exception);
        }
        catch (SAXException exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private Collection<FileAnnotation> convert(Pmd collection, String moduleName) {
        ArrayList<FileAnnotation> annotations = new ArrayList<FileAnnotation>();
        for (File file : collection.getFiles()) {
            for (Violation warning : file.getViolations()) {
                Priority priority = warning.getPriority() < 3 ? Priority.HIGH : (warning.getPriority() > 4 ? Priority.LOW : Priority.NORMAL);
                Bug bug = new Bug(priority, warning.getMessage() + ".", warning.getRuleset(), warning.getRule(), warning.getBeginline(), warning.getEndline());
                bug.setPackageName(warning.getPackage());
                bug.setModuleName(moduleName);
                bug.setFileName(file.getName());
                try {
                    bug.setContextHashCode((long)this.createContextHashCode(file.getName(), warning.getBeginline()));
                }
                catch (IOException exception) {
                    // empty catch block
                }
                annotations.add((FileAnnotation)bug);
            }
        }
        return annotations;
    }
}

