/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.pmd.PmdDescriptor;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.PmdResultAction;
import hudson.plugins.pmd.PmdResultBuilder;
import hudson.plugins.pmd.parser.PmdParser;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 6711252664481150129L;
    private static final String DEFAULT_PATTERN = "**/pmd.xml";
    private final String pattern;

    @DataBoundConstructor
    public PmdPublisher(String pattern, String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String defaultEncoding) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, defaultEncoding, "PMD");
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new PmdProjectAction(project);
    }

    public BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Collecting PMD analysis files...");
        FilesParser pmdCollector = new FilesParser(logger, StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), (AnnotationParser)new PmdParser(this.getDefaultEncoding()), this.isMavenBuild(build), this.isAntBuild(build));
        ParserResult project = (ParserResult)build.getWorkspace().act((FilePath.FileCallable)pmdCollector);
        PmdResult result = new PmdResultBuilder().build(build, project, this.getDefaultEncoding());
        build.getActions().add(new PmdResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public PmdDescriptor getDescriptor() {
        return (PmdDescriptor)super.getDescriptor();
    }
}

