/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pmd;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwareMavenReporter;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.pmd.MavenPmdResultAction;
import hudson.plugins.pmd.PmdProjectAction;
import hudson.plugins.pmd.PmdResult;
import hudson.plugins.pmd.parser.PmdParser;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PmdReporter
extends HealthAwareMavenReporter {
    private static final long serialVersionUID = 2272875032054063496L;
    private static final String PMD_XML_FILE = "pmd.xml";
    private String pattern;

    @DataBoundConstructor
    public PmdReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, boolean canRunOnFailed) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, canRunOnFailed, "PMD");
    }

    protected boolean acceptGoal(String goal) {
        return "pmd".equals(goal) || "site".equals(goal);
    }

    public ParserResult perform(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, PluginLogger logger) throws InterruptedException, IOException {
        FilesParser pmdCollector = new FilesParser(logger, PMD_XML_FILE, (AnnotationParser)new PmdParser(this.getDefaultEncoding()), true, false);
        return (ParserResult)this.getTargetPath(pom).act((FilePath.FileCallable)pmdCollector);
    }

    protected BuildResult persistResult(ParserResult project, MavenBuild build) {
        PmdResult result = new PmdResult((AbstractBuild<?, ?>)build, this.getDefaultEncoding(), project);
        build.getActions().add(new MavenPmdResultAction((AbstractBuild<?, ?>)build, (HealthDescriptor)this, this.getDefaultEncoding(), result));
        build.registerAsProjectAction((MavenReporter)this);
        return result;
    }

    public List<PmdProjectAction> getProjectActions(MavenModule module) {
        return Collections.singletonList(new PmdProjectAction((AbstractProject<?, ?>)module));
    }

    protected Class<? extends Action> getResultActionClass() {
        return MavenPmdResultAction.class;
    }
}

