/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.polarion;

import hudson.model.Descriptor;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SubversionChangeLogSet;
import hudson.scm.SubversionRepositoryBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;

public class PolarionRepositoryBrowser
extends SubversionRepositoryBrowser {
    private static final String CHANGE_SET_FORMAT = "revisionDetails.jsp?location=/&rev=%d";
    private static final String DIFF_FORMAT = "changedResource.jsp?location=/&url=%s&rev=%d&action=%s";
    private static final String FILE_FORMAT = "fileContent.jsp?location=/&url=%s";
    private static final Map editTypeMap = new HashMap();
    public final URL url;
    public static final DescriptorImpl DESCRIPTOR;

    public PolarionRepositoryBrowser(URL url) throws MalformedURLException {
        this.url = PolarionRepositoryBrowser.normalizeToEndWithSlash((URL)url);
    }

    public URL getDiffLink(SubversionChangeLogSet.Path path) throws IOException {
        if (!editTypeMap.containsKey(path.getEditType())) {
            return null;
        }
        String editType = (String)editTypeMap.get(path.getEditType());
        return new URL(this.url, String.format(DIFF_FORMAT, path.getValue(), path.getLogEntry().getRevision(), editType));
    }

    public URL getFileLink(SubversionChangeLogSet.Path path) throws IOException {
        return new URL(this.url, String.format(FILE_FORMAT, path.getValue()));
    }

    public URL getChangeSetLink(SubversionChangeLogSet.LogEntry changeSet) throws IOException {
        return new URL(this.url, String.format(CHANGE_SET_FORMAT, changeSet.getRevision()));
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    static {
        editTypeMap.put(EditType.ADD, "add");
        editTypeMap.put(EditType.EDIT, "modify");
        editTypeMap.put(EditType.DELETE, "delete");
        DESCRIPTOR = new DescriptorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(PolarionRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "Polarion Web Client";
        }

        public PolarionRepositoryBrowser newInstance(StaplerRequest req) throws Descriptor.FormException {
            return (PolarionRepositoryBrowser)((Object)req.bindParameters(PolarionRepositoryBrowser.class, "polarion."));
        }
    }
}

