/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.postbuildtask;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.postbuildtask.PostbuildTask;
import hudson.plugins.postbuildtask.TaskProperties;
import hudson.tasks.BatchFile;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Publisher;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostbuildTask
extends Publisher {
    private volatile TaskProperties[] tasks;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public PostbuildTask(TaskProperties ... tasks) {
        this.tasks = tasks;
    }

    public PostbuildTask(Collection<TaskProperties> tasks) {
        this(tasks.toArray(new TaskProperties[tasks.size()]));
    }

    public TaskProperties getTask(String logText) {
        for (TaskProperties t : this.tasks) {
            if (!t.logText.equals(logText)) continue;
            return t;
        }
        return null;
    }

    public List<TaskProperties> getTasks() {
        return Collections.unmodifiableList(Arrays.asList(this.tasks));
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String buildLog = build.getLog();
        listener.getLogger().println("Performing Post build task...");
        try {
            for (int i = 0; i < this.tasks.length; ++i) {
                TaskProperties taskProperties = this.tasks[i];
                Pattern pattern = Pattern.compile(taskProperties.logText);
                Matcher matcher = pattern.matcher(buildLog);
                if (matcher.find()) {
                    listener.getLogger().println("Found Matching text in the log : " + matcher.group());
                    String script = taskProperties.script;
                    for (int k = 0; k <= matcher.groupCount(); ++k) {
                        script = script.replace("%" + k, matcher.group(k));
                    }
                    listener.getLogger().println("Executing the batch command : " + script);
                    CommandInterpreter runner = this.getCommandInterpreter(launcher, script);
                    Result result = runner.perform(build, launcher, listener) ? Result.SUCCESS : Result.FAILURE;
                    listener.getLogger().println("POST BUILD TASK : " + result.toString());
                    continue;
                }
                listener.getLogger().println("Could not match : " + taskProperties.logText);
                listener.getLogger().println("POST BUILD TASK : " + Result.SUCCESS);
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Exception when executing the batch command : " + e.getMessage());
            return false;
        }
        return true;
    }

    private CommandInterpreter getCommandInterpreter(Launcher launcher, String script) {
        if (launcher.isUnix()) {
            return new Shell(script);
        }
        return new BatchFile(script);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }
}

