/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.postbuildtask;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.postbuildtask.LogProperties;
import hudson.plugins.postbuildtask.PostbuildTask;
import hudson.plugins.postbuildtask.TaskProperties;
import hudson.tasks.BatchFile;
import hudson.tasks.CommandInterpreter;
import hudson.tasks.Publisher;
import hudson.tasks.Shell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostbuildTask
extends Publisher {
    private volatile TaskProperties[] tasks;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public PostbuildTask(TaskProperties ... tasks) {
        this.tasks = tasks;
    }

    public PostbuildTask(Collection<TaskProperties> tasks) {
        this(tasks.toArray(new TaskProperties[tasks.size()]));
    }

    public TaskProperties[] getAllTasks() {
        return this.tasks;
    }

    public List<TaskProperties> getTasks() {
        if (this.tasks == null) {
            return new ArrayList<TaskProperties>();
        }
        return Collections.unmodifiableList(Arrays.asList(this.tasks));
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String buildLog = build.getLog();
        listener.getLogger().println("Performing Post build task...");
        try {
            for (int i = 0; i < this.tasks.length; ++i) {
                TaskProperties taskProperties = this.tasks[i];
                String script = taskProperties.script;
                if (this.checkLogTextMatch(taskProperties.getLogProperties(), buildLog, listener)) {
                    listener.getLogger().println("Logical operation result is TRUE");
                    listener.getLogger().println("Running script  : " + script);
                    CommandInterpreter runner = this.getCommandInterpreter(launcher, script);
                    Result result = runner.perform(build, launcher, listener) ? Result.SUCCESS : Result.FAILURE;
                    listener.getLogger().println("POST BUILD TASK : " + result.toString());
                    listener.getLogger().println("END OF POST BUILD TASK : " + i);
                    continue;
                }
                listener.getLogger().println("Logical operation result is FALSE");
                listener.getLogger().println("Skipping script  : " + script);
                listener.getLogger().println("END OF POST BUILD TASK \t: " + i);
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Exception when executing the batch command : " + e.getMessage());
            return false;
        }
        return true;
    }

    private String getGroupedScript(LogProperties[] logTexts, String script, String buildLog) {
        StringBuilder appendedLogs = new StringBuilder();
        for (int i = 0; i < logTexts.length; ++i) {
            LogProperties logInfo = logTexts[i];
            Pattern pattern = Pattern.compile(logInfo.getLogText());
            Matcher matcher = pattern.matcher(buildLog);
            for (int k = 0; k < matcher.groupCount(); ++k) {
                script = script.replace("%" + k, matcher.group(k));
            }
        }
        return script;
    }

    private boolean checkLogTextMatch(LogProperties[] logTexts, String buildLog, BuildListener listener) {
        boolean logmatch = false;
        boolean match1 = false;
        boolean match2 = false;
        String operator1 = "";
        for (int i = 0; i < logTexts.length; ++i) {
            LogProperties logInfo = logTexts[i];
            String logText = logInfo.getLogText();
            String operator = logInfo.getOperator();
            match1 = this.isMatching(buildLog, logText, listener);
            if (i != 0) {
                match1 = this.doOperation(logmatch, match1, operator1);
            } else {
                logmatch = match1;
            }
            if (++i < logTexts.length) {
                LogProperties logInfo1 = logTexts[i];
                String logText1 = logInfo1.getLogText();
                operator1 = logInfo1.getOperator();
                match2 = this.isMatching(buildLog, logText1, listener);
                logmatch = this.doOperation(match1, match2, operator);
                continue;
            }
            logmatch = match1;
        }
        return logmatch;
    }

    private boolean doOperation(boolean match1, boolean match2, String operation) {
        if (operation.equals("AND")) {
            return match1 & match2;
        }
        return match1 | match2;
    }

    private boolean isMatching(String buildLog, String logText, BuildListener listener) {
        Pattern pattern = Pattern.compile(logText);
        Matcher matcher = pattern.matcher(buildLog);
        boolean match = matcher.find();
        if (match) {
            listener.getLogger().println("Match found for :" + logText + " : True");
        } else {
            listener.getLogger().println("Could not match :" + logText + "  : False");
        }
        return match;
    }

    private CommandInterpreter getCommandInterpreter(Launcher launcher, String script) {
        if (launcher.isUnix()) {
            return new Shell(script);
        }
        return new BatchFile(script);
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }
}

