/*
 * Decompiled with CFR 0.152.
 */
package dk.hlyh.ciplugins.prereqbuildstep;

import dk.hlyh.ciplugins.prereqbuildstep.PrereqDescriptor;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.Builder;
import java.io.PrintStream;
import java.util.ArrayList;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrereqBuilder
extends Builder {
    @Extension
    public static final PrereqDescriptor DESCRIPTOR = new PrereqDescriptor();
    private static final boolean DEBUG = false;
    private final String projects;
    private final Boolean warningOnly;

    public String getProjects() {
        return this.projects;
    }

    public Boolean getWarningOnly() {
        return this.warningOnly;
    }

    @DataBoundConstructor
    public PrereqBuilder(String projects, Boolean warningOnly) {
        this.projects = Util.fixEmptyAndTrim((String)projects);
        this.warningOnly = warningOnly;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        boolean result;
        boolean checkPassed = true;
        PrintStream logger = listener.getLogger();
        long start = System.currentTimeMillis();
        ArrayList buildsChecked = new ArrayList();
        logger.println("Prerequisites check: projects='" + this.projects + "', warningOnly='" + this.warningOnly + "'");
        for (String projectName : this.projects.split(",")) {
            AbstractProject upstreamJob = (AbstractProject)Hudson.getInstance().getItemByFullName(projectName, AbstractProject.class);
            if (upstreamJob == null) {
                logger.println("Prerequisites check: Job '" + projectName + "' not found");
                checkPassed = false;
                continue;
            }
            if (upstreamJob.isBuilding()) {
                logger.println("Prerequisites check: Job '" + projectName + "' is building");
                checkPassed = false;
                continue;
            }
            Run lastBuild = upstreamJob.getLastBuild();
            if (lastBuild == null) {
                logger.println("Prerequisites check: Job '" + projectName + "' has not been built");
                checkPassed = false;
                continue;
            }
            Result result2 = lastBuild.getResult();
            logger.println("Prerequisites check: Job '" + lastBuild.getFullDisplayName() + "' has status " + result2);
            if (!result2.isWorseThan(Result.SUCCESS)) continue;
            checkPassed = false;
        }
        boolean bl = result = this.warningOnly != false ? true : checkPassed;
        if (checkPassed) {
            logger.println("Prerequisites check: All checks passed ");
        } else if (!checkPassed && !this.warningOnly.booleanValue()) {
            logger.println("Prerequisites check: Some checks failed ");
        } else if (!checkPassed && this.warningOnly.booleanValue()) {
            logger.println("Prerequisites check: Some checks failed, but in warning only mode");
        }
        return result;
    }
}

