/*
 * Decompiled with CFR 0.152.
 */
package dk.hlyh.ciplugins.projecthealth;

import dk.hlyh.ciplugins.projecthealth.TestFailure;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectHealthProjectAction
implements Action {
    private static final Logger LOG = Logger.getLogger(ProjectHealthProjectAction.class.getName());
    private final AbstractProject<?, ?> project;
    private Hudson hudson;
    private volatile List<TestFailure> failures;
    private volatile List<Run<?, ?>> builds;
    private volatile Run<?, ?> firstbuild;
    private volatile Run<?, ?> lastbuild;
    private volatile String currentSelection;

    public ProjectHealthProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
        this.hudson = Hudson.getInstance();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Project Health";
    }

    public String getUrlName() {
        return "project-health";
    }

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public RunList<?> getAllBuilds() {
        RunList allBuilds = this.project.getBuilds();
        String optionParam = Stapler.getCurrentRequest().getParameter("option");
        String numOfBuildsParam = Stapler.getCurrentRequest().getParameter("num");
        String firstBuildParam = Stapler.getCurrentRequest().getParameter("firstBuild");
        String oldestBuildParam = Stapler.getCurrentRequest().getParameter("oldestBuild");
        LOG.fine("Project health report called with: [option=" + optionParam + ", numOfBuilds=" + numOfBuildsParam + ", firstBuild=" + firstBuildParam + ", oldestBuikd=" + oldestBuildParam + "]");
        if (optionParam != null && optionParam.equalsIgnoreCase("recent")) {
            try {
                int limit = Integer.parseInt(numOfBuildsParam);
                this.builds = allBuilds.subList(0, limit);
            }
            catch (NumberFormatException e) {
                this.builds = allBuilds;
            }
        } else if (optionParam != null && optionParam.equalsIgnoreCase("period")) {
            try {
                long first = Long.parseLong(firstBuildParam);
                long oldest = Long.parseLong(oldestBuildParam);
                if (oldest > first) {
                    long tmp = oldest;
                    oldest = first;
                    first = tmp;
                }
                this.builds = allBuilds.byTimestamp(--oldest, ++first);
            }
            catch (NumberFormatException e) {
                this.builds = allBuilds;
            }
        } else {
            this.builds = allBuilds;
        }
        this.firstbuild = this.builds.get(0);
        this.lastbuild = this.builds.get(this.builds.size() - 1);
        return allBuilds;
    }

    public int getNumberOfBuilds() {
        return this.builds.size();
    }

    public int getNumberOfFailedBuilds() {
        HashMap<String, TestFailure> resultMap = new HashMap<String, TestFailure>();
        int numberOfFailed = 0;
        for (Run<?, ?> build : this.builds) {
            if (build.isBuilding() || !build.getResult().isWorseThan(Result.SUCCESS)) continue;
            ++numberOfFailed;
            this.getFailuresForRun(resultMap, build);
        }
        this.failures = new ArrayList(resultMap.values());
        Collections.sort(this.failures);
        return numberOfFailed;
    }

    public int getNumberOfSuccessBuilds() {
        return this.builds.size() - this.getNumberOfFailedBuilds();
    }

    public boolean getHasFailures() {
        return this.getFailures().size() > 0;
    }

    public String getCurrentSelection() {
        return this.currentSelection;
    }

    public Run<?, ?> getFirstbuild() {
        return this.firstbuild;
    }

    public Run<?, ?> getLastbuild() {
        return this.lastbuild;
    }

    public String getOverviewPie() {
        int totalBuilds = this.getNumberOfSuccessBuilds() + this.getNumberOfFailedBuilds();
        int successPct = this.getNumberOfSuccessBuilds() * 100 / totalBuilds;
        int failedPct = this.getNumberOfFailedBuilds() * 100 / totalBuilds;
        String result = "https://chart.googleapis.com/chart?cht=p&chs=250x100";
        result = result + "&chd=t:" + successPct + "," + failedPct;
        result = result + "&chl=Success|Failure";
        result = result + "&chco=729FCF,EF2929";
        result = result + "&chtt=Project%20health";
        return result;
    }

    public String getFailurePie() {
        String result = "https://chart.googleapis.com/chart?cht=p&chs=850x300";
        String legends = null;
        String datas = null;
        int totalFailures = 0;
        for (TestFailure failure : this.getFailures()) {
            totalFailures += failure.getCount();
        }
        for (TestFailure failure : this.getFailures()) {
            int failurePct = failure.getCount() * 100 / totalFailures;
            String shortName = failure.getTestcase().substring(failure.getTestcase().lastIndexOf(".") + 1);
            legends = legends == null ? shortName : legends + "|" + shortName;
            if (datas == null) {
                datas = "" + failurePct;
                continue;
            }
            datas = datas + "," + failurePct;
        }
        result = result + "&chd=t:" + datas;
        result = result + "&chl=" + legends;
        result = result + "&chtt=Test+Failures";
        result = result + "&chco=EF2929";
        return result;
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    private void getFailuresForRun(Map<String, TestFailure> failures, Run<?, ?> build) {
        AbstractTestResultAction tests = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        if (tests == null) {
            return;
        }
        List failedTests = tests.getFailedTests();
        for (CaseResult result : failedTests) {
            String name = result.getFullName();
            TestFailure failure = failures.get(name);
            if (failure == null) {
                failure = new TestFailure();
                failure.setTestcase(name);
                failure.setCount(0);
                failures.put(name, failure);
            }
            failure.setCount(failure.getCount() + 1);
        }
    }
}

