/*
 * Decompiled with CFR 0.152.
 */
package dk.hlyh.ciplugins.projecthealth;

import dk.hlyh.ciplugins.projecthealth.TestFailure;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectHealthProjectAction
implements Action {
    private static final Logger LOG = Logger.getLogger(ProjectHealthProjectAction.class.getName());
    private final AbstractProject<?, ?> project;
    private final Hudson hudson;
    private volatile transient List<Run<?, ?>> builds;
    private volatile transient long successCount;
    private volatile transient long failureCount;
    private volatile transient long totalTestFailures;
    private volatile transient List<TestFailure> failures;
    private volatile transient Run<?, ?> firstbuild;
    private volatile transient Run<?, ?> lastbuild;

    public ProjectHealthProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
        this.hudson = Hudson.getInstance();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Project Health";
    }

    public String getUrlName() {
        return "project-health";
    }

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public RunList<?> getAllBuilds() {
        RunList allBuilds = this.project.getBuilds();
        this.resetCaches();
        this.setBuildLimit(allBuilds);
        this.calculateTestFailures();
        return allBuilds;
    }

    public int getNumberOfBuilds() {
        return this.builds.size();
    }

    public long getNumberOfFailedBuilds() {
        return this.failureCount;
    }

    public long getNumberOfSuccessBuilds() {
        return this.successCount;
    }

    public boolean getHasFailures() {
        return this.totalTestFailures > 0L;
    }

    public Run<?, ?> getFirstbuild() {
        return this.firstbuild;
    }

    public Run<?, ?> getLastbuild() {
        return this.lastbuild;
    }

    public String getOverviewPie() {
        long successPct = this.getNumberOfSuccessBuilds() * 100L / (long)this.getNumberOfBuilds();
        long failedPct = this.getNumberOfFailedBuilds() * 100L / (long)this.getNumberOfBuilds();
        String result = "https://chart.googleapis.com/chart?cht=p&chs=250x100";
        result = result + "&chd=t:" + successPct + "," + failedPct;
        result = result + "&chl=Success|Failure";
        result = result + "&chco=729FCF,EF2929";
        result = result + "&chtt=Project%20health";
        return result;
    }

    public String getFailurePie() {
        StringBuilder result = new StringBuilder(1024);
        StringBuilder legends = new StringBuilder(1024);
        StringBuilder datas = new StringBuilder(1024);
        boolean first = true;
        for (TestFailure failure : this.getFailures()) {
            long failurePct = (long)(failure.getCount() * 100) / this.totalTestFailures;
            String shortName = failure.getTestcase().substring(failure.getTestcase().lastIndexOf(".") + 1);
            if (first) {
                legends.append(shortName);
                datas.append(failurePct);
            } else {
                legends.append("|").append(shortName);
                datas.append(",").append(failurePct);
            }
            first = false;
        }
        result.append("https://chart.googleapis.com/chart?cht=p&chs=850x300");
        result.append("&chd=t:").append((CharSequence)datas);
        result.append("&chl=").append((CharSequence)legends);
        result.append("&chtt=Test+Failures&chco=EF2929");
        return result.toString();
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    private void resetCaches() {
        this.builds = null;
        this.successCount = 0L;
        this.failureCount = 0L;
        this.failures = null;
        this.firstbuild = null;
        this.lastbuild = null;
    }

    private void setBuildLimit(RunList<?> allBuilds) {
        String optionParam = Stapler.getCurrentRequest().getParameter("option");
        String numOfBuildsParam = Stapler.getCurrentRequest().getParameter("num");
        String firstBuildParam = Stapler.getCurrentRequest().getParameter("firstBuild");
        String oldestBuildParam = Stapler.getCurrentRequest().getParameter("oldestBuild");
        LOG.fine("Project health report called with: [option=" + optionParam + ", numOfBuilds=" + numOfBuildsParam + ", firstBuild=" + firstBuildParam + ", oldestBuikd=" + oldestBuildParam + "]");
        if (optionParam != null && optionParam.equalsIgnoreCase("recent")) {
            try {
                int limit = Integer.parseInt(numOfBuildsParam);
                this.builds = allBuilds.subList(0, limit);
            }
            catch (NumberFormatException e) {
                this.builds = allBuilds;
            }
        } else if (optionParam != null && optionParam.equalsIgnoreCase("period")) {
            try {
                long first = Long.parseLong(firstBuildParam);
                long oldest = Long.parseLong(oldestBuildParam);
                if (oldest > first) {
                    long tmp = oldest;
                    oldest = first;
                    first = tmp;
                }
                this.builds = allBuilds.byTimestamp(--oldest, ++first);
            }
            catch (NumberFormatException e) {
                this.builds = allBuilds;
            }
        } else {
            this.builds = allBuilds;
        }
        this.firstbuild = (Run)this.builds.get(0);
        this.lastbuild = (Run)this.builds.get(this.builds.size() - 1);
    }

    private void calculateTestFailures() {
        HashMap resultMap = new HashMap();
        for (Run build : this.builds) {
            if (build.isBuilding()) continue;
            if (build.getResult().isWorseThan(Result.SUCCESS)) {
                ++this.failureCount;
                this.getFailuresForRun(resultMap, build);
                continue;
            }
            ++this.successCount;
        }
        this.failures = new ArrayList(resultMap.values());
        Collections.sort(this.failures);
    }

    private void getFailuresForRun(Map<String, TestFailure> failures, Run<?, ?> build) {
        AbstractTestResultAction tests = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        if (tests == null) {
            return;
        }
        List failedTests = tests.getFailedTests();
        for (CaseResult result : failedTests) {
            String name = result.getFullName();
            TestFailure failure = failures.get(name);
            if (failure == null) {
                failure = new TestFailure();
                failure.setTestcase(name);
                failure.setCount(0);
                failures.put(name, failure);
            }
            failure.setCount(failure.getCount() + 1);
            ++this.totalTestFailures;
        }
    }
}

