/*
 * Decompiled with CFR 0.152.
 */
package dk.hlyh.ciplugins.projecthealth;

import dk.hlyh.ciplugins.projecthealth.ProjectHealthState;
import dk.hlyh.ciplugins.projecthealth.TestFailure;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.kohsuke.stapler.Stapler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectHealthProjectAction
implements Action {
    private static final Logger LOG = Logger.getLogger(ProjectHealthProjectAction.class.getName());
    private final AbstractProject<?, ?> project;
    private final Hudson hudson;

    public ProjectHealthProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
        this.hudson = Hudson.getInstance();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getDisplayName() {
        return "Project Health";
    }

    public String getUrlName() {
        return "project-health";
    }

    public final AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public ProjectHealthState getState() {
        ProjectHealthState state = new ProjectHealthState();
        state.setAllBuilds(this.project.getBuilds());
        this.parseInput(state);
        this.setBuildLimit(state);
        this.calculateTestFailures(state);
        this.calculateGraphs(state);
        return state;
    }

    private void parseInput(ProjectHealthState state) {
        String optionParam = Stapler.getCurrentRequest().getParameter("option");
        String numOfBuildsParam = Stapler.getCurrentRequest().getParameter("num");
        String firstBuildParam = Stapler.getCurrentRequest().getParameter("firstBuild");
        String oldestBuildParam = Stapler.getCurrentRequest().getParameter("oldestBuild");
        String groupOnErrorMessageParam = Stapler.getCurrentRequest().getParameter("groupOnErrorMsg");
        LOG.fine("Project Health plugin called with: optionParam" + optionParam + ", numOfBuildsParam=" + numOfBuildsParam + ", firstBuildParam=" + firstBuildParam + ", oldestBuildParam" + oldestBuildParam + ", groupOnErrorMessageParam=" + groupOnErrorMessageParam);
        ProjectHealthState.OptionValue option = null;
        try {
            option = ProjectHealthState.OptionValue.valueOf(optionParam);
        }
        catch (IllegalArgumentException ex) {
            option = ProjectHealthState.OptionValue.All;
        }
        catch (NullPointerException ex) {
            option = ProjectHealthState.OptionValue.All;
        }
        state.setOptionParameter(option);
        if (numOfBuildsParam != null && !numOfBuildsParam.trim().isEmpty()) {
            try {
                state.setRecentBuildsParameter(Integer.parseInt(numOfBuildsParam));
            }
            catch (NumberFormatException e) {
                state.setOptionParameter(ProjectHealthState.OptionValue.All);
            }
        }
        if (firstBuildParam != null && !firstBuildParam.trim().isEmpty() && oldestBuildParam != null && !oldestBuildParam.trim().isEmpty()) {
            try {
                long first = Long.parseLong(firstBuildParam);
                long last = Long.parseLong(oldestBuildParam);
                if (last > first) {
                    long tmp = last;
                    last = first;
                    first = tmp;
                }
                state.setFirstBuildParameter(++first);
                state.setLastBuildParameter(--last);
            }
            catch (NumberFormatException e) {
                state.setOptionParameter(ProjectHealthState.OptionValue.All);
            }
        }
        state.setGroupOnErrorMessageParameter(Boolean.parseBoolean(groupOnErrorMessageParam));
        LOG.fine("Project Health plugin called with (parsed): optionParam" + (Object)((Object)state.getOptionParameter()) + ", numOfBuildsParam=" + state.getRecentBuildsParameter() + ", firstBuildParam=" + state.getFirstBuildParameter() + ", oldestBuildParam" + state.getLastBuildParameter() + ", groupOnErrorMessageParam=" + state.isGroupOnErrorMessageParameter());
    }

    private void setBuildLimit(ProjectHealthState state) {
        Object selectedBuilds;
        switch (state.getOptionParameter()) {
            case Recent: {
                if (state.getRecentBuildsParameter() > 0 && state.getRecentBuildsParameter() < state.getAllBuilds().size()) {
                    selectedBuilds = state.getAllBuilds().subList(0, state.getRecentBuildsParameter());
                    break;
                }
                selectedBuilds = state.getAllBuilds();
                state.setOptionParameter(ProjectHealthState.OptionValue.All);
                break;
            }
            case Period: {
                selectedBuilds = state.getAllBuilds().byTimestamp(state.getLastBuildParameter(), state.getFirstBuildParameter());
                break;
            }
            case All: {
                selectedBuilds = state.getAllBuilds();
                break;
            }
            default: {
                selectedBuilds = state.getAllBuilds();
            }
        }
        state.setTotalBuilds(selectedBuilds.size());
        state.setSelectedBuilds((List<Run<?, ?>>)selectedBuilds);
        state.setFirstSelectedBuild((Run)selectedBuilds.get(0));
        state.setLastSelectedBuild((Run)selectedBuilds.get(selectedBuilds.size() - 1));
    }

    private void calculateTestFailures(ProjectHealthState state) {
        HashMap<String, TestFailure> resultMap = new HashMap<String, TestFailure>();
        int failureCount = 0;
        int successCount = 0;
        int testcaseFailures = 0;
        boolean groupByErrorMessage = state.isGroupOnErrorMessageParameter();
        for (Run<?, ?> build : state.getSelectedBuilds()) {
            if (build.isBuilding()) continue;
            if (build.getResult().isWorseThan(Result.SUCCESS)) {
                ++failureCount;
                testcaseFailures += this.getFailuresForRun(groupByErrorMessage, resultMap, build);
                continue;
            }
            ++successCount;
        }
        state.setFailedBuilds(failureCount);
        state.setGoodBuilds(successCount);
        state.setTotalFailures(testcaseFailures);
        state.setFailures(new ArrayList<TestFailure>(resultMap.values()));
    }

    private int getFailuresForRun(boolean groupByErrorMessage, Map<String, TestFailure> failures, Run<?, ?> build) {
        AbstractTestResultAction tests = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        int testFailures = 0;
        if (tests == null) {
            return 0;
        }
        List failedTests = tests.getFailedTests();
        for (CaseResult result : failedTests) {
            TestFailure failure;
            String name = result.getFullName();
            if (groupByErrorMessage) {
                name = name + ": " + result.getErrorDetails();
            }
            if ((failure = failures.get(name)) == null) {
                failure = new TestFailure();
                failure.setTestcase(name);
                failure.setCount(0);
                failures.put(name, failure);
            }
            failure.setCount(failure.getCount() + 1);
            ++testFailures;
        }
        return testFailures;
    }

    private void calculateGraphs(ProjectHealthState state) {
        state.setOverviewPie(this.getOverviewPie(state));
        state.setFailuresPie(this.getFailurePie(state));
    }

    public String getOverviewPie(ProjectHealthState state) {
        long successPct = state.getGoodBuilds() * 100 / state.getSelectedBuilds().size();
        long failedPct = state.getFailedBuilds() * 100 / state.getSelectedBuilds().size();
        String result = "https://chart.googleapis.com/chart?cht=p&chs=250x100";
        result = result + "&chd=t:" + successPct + "," + failedPct;
        result = result + "&chl=Success|Failure";
        result = result + "&chco=729FCF,EF2929";
        result = result + "&chtt=Project%20health";
        return result;
    }

    public String getFailurePie(ProjectHealthState state) {
        StringBuilder result = new StringBuilder(1024);
        StringBuilder legends = new StringBuilder(1024);
        StringBuilder datas = new StringBuilder(1024);
        boolean first = true;
        for (TestFailure failure : state.getFailures()) {
            long failurePct = failure.getCount() * 100 / state.getTotalFailures();
            String shortName = failure.getTestcase().substring(failure.getTestcase().lastIndexOf(".") + 1);
            if (first) {
                legends.append(shortName);
                datas.append(failurePct);
            } else {
                legends.append("|").append(shortName);
                datas.append(",").append(failurePct);
            }
            first = false;
        }
        result.append("https://chart.googleapis.com/chart?cht=p&chs=850x300");
        result.append("&chd=t:").append((CharSequence)datas);
        result.append("&chl=").append((CharSequence)legends);
        result.append("&chtt=Test+Failures&chco=EF2929");
        return result.toString();
    }
}

