/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds_simple;

import hudson.EnvVars;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildSelector;
import hudson.plugins.copyartifact.SimpleBuildSelectorDescriptor;
import hudson.plugins.promoted_builds_simple.Messages;
import hudson.plugins.promoted_builds_simple.PromoteAction;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotedBuildSelector
extends BuildSelector {
    private static final String LEVEL_PARAM_NAME = "COPY_PROMOTION_LEVEL";
    private int level;
    public static final Descriptor<BuildSelector> DESCRIPTOR = new SimpleBuildSelectorDescriptor(PromotedBuildSelector.class, Messages._PromotedBuildSelector_DisplayName());

    @DataBoundConstructor
    public PromotedBuildSelector(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isSelectable(Run<?, ?> run, EnvVars env) {
        PromoteAction pa = (PromoteAction)run.getAction(PromoteAction.class);
        if (pa == null) {
            return false;
        }
        int checkLevel = this.level;
        if (checkLevel == 0) {
            try {
                checkLevel = Integer.parseInt((String)env.get((Object)LEVEL_PARAM_NAME));
            }
            catch (NumberFormatException nfe) {
                checkLevel = Integer.MAX_VALUE;
            }
        }
        return pa.getLevelValue() >= checkLevel;
    }
}

