/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds_simple;

import hudson.Plugin;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.promoted_builds_simple.PromoteAction;
import hudson.plugins.promoted_builds_simple.PromotedBuildSelector;
import hudson.plugins.promoted_builds_simple.PromotionLevel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotedBuildsSimplePlugin
extends Plugin {
    private List<PromotionLevel> levels = new ArrayList<PromotionLevel>();

    public void start() throws Exception {
        this.levels.add(new PromotionLevel("QA build", "qa.gif"));
        this.levels.add(new PromotionLevel("QA approved", "qa-green.gif"));
        this.levels.add(new PromotionLevel("GA release", "ga.gif"));
        this.load();
    }

    public List<PromotionLevel> getLevels() {
        return this.levels;
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        this.levels.clear();
        this.levels.addAll(req.bindJSONToList(PromotionLevel.class, formData.get("levels")));
        this.save();
    }

    public void doMakePromotable(StaplerRequest req, StaplerResponse rsp) throws IOException {
        ((Job)req.findAncestorObject(Job.class)).checkPermission(Run.UPDATE);
        Run run = (Run)req.findAncestorObject(Run.class);
        if (run != null) {
            run.addAction((Action)new PromoteAction());
            run.save();
            rsp.sendRedirect(req.getRequestURI().substring(0, req.getRequestURI().indexOf("parent/parent")));
        }
    }

    public static Descriptor initBuildSelector() {
        try {
            Class.forName("hudson.plugins.copyartifact.BuildSelector");
            return PromotedBuildSelector.DESCRIPTOR;
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PromotedBuildsRunListener
    extends RunListener<Run> {
        public PromotedBuildsRunListener() {
            super(Run.class);
        }

        public void onCompleted(Run run, TaskListener listener) {
            Result res = run.getResult();
            if (res != Result.FAILURE && res != Result.ABORTED) {
                run.addAction((Action)new PromoteAction());
            }
        }
    }
}

