/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.PermalinkProjectAction;
import hudson.model.ProminentProjectAction;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotionProcess;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotedProjectAction
implements ProminentProjectAction,
PermalinkProjectAction {
    public final AbstractProject<?, ?> owner;
    private final JobPropertyImpl property;

    public PromotedProjectAction(AbstractProject<?, ?> owner, JobPropertyImpl property) {
        this.owner = owner;
        this.property = property;
    }

    public List<PromotionProcess> getProcesses() {
        return this.property.getActiveItems();
    }

    public AbstractBuild<?, ?> getLatest(PromotionProcess p) {
        return this.getLatest(p.getName());
    }

    public AbstractBuild<?, ?> getLatest(String name) {
        for (AbstractBuild build : this.owner.getBuilds()) {
            PromotedBuildAction a = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
            if (a == null || !a.contains(name)) continue;
            return build;
        }
        return null;
    }

    public List<PermalinkProjectAction.Permalink> getPermalinks() {
        ArrayList<PermalinkProjectAction.Permalink> r = new ArrayList<PermalinkProjectAction.Permalink>();
        for (PromotionProcess pp : this.property.getActiveItems()) {
            r.add(pp.asPermalink());
        }
        return r;
    }

    public String getIconFileName() {
        return "star.gif";
    }

    public String getDisplayName() {
        return "Promotion Status";
    }

    public String getUrlName() {
        return "promotion";
    }
}

