/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.Status;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Promotion
extends AbstractBuild<PromotionProcess, Promotion> {
    private int targetBuildNumber;
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(Promotion.class, null);
    public static final Permission PROMOTE = new Permission(PERMISSIONS, "Promote", null, Hudson.ADMINISTER);

    public Promotion(PromotionProcess job) throws IOException {
        super((AbstractProject)job);
    }

    public Promotion(PromotionProcess job, Calendar timestamp) {
        super((AbstractProject)job, timestamp);
    }

    public Promotion(PromotionProcess project, File buildDir) throws IOException {
        super((AbstractProject)project, buildDir);
    }

    public AbstractBuild<?, ?> getTarget() {
        return (AbstractBuild)((PromotionProcess)this.getParent()).getOwner().getBuildByNumber(this.targetBuildNumber);
    }

    public Status getStatus() {
        return ((PromotedBuildAction)this.getTarget().getAction(PromotedBuildAction.class)).getPromotion(((PromotionProcess)this.getParent()).getName());
    }

    public EnvVars getEnvironment(TaskListener listener) throws IOException, InterruptedException {
        EnvVars e = super.getEnvironment(listener);
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null && this.targetBuildNumber != 0) {
            e.put("PROMOTED_URL", rootUrl + this.getTarget().getUrl());
        }
        return e;
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl(this));
    }

    static /* synthetic */ int access$002(Promotion x0, int x1) {
        x0.targetBuildNumber = x1;
        return x0.targetBuildNumber;
    }

    static /* synthetic */ Job access$100(Promotion x0) {
        return x0.project;
    }

    static /* synthetic */ Job access$200(Promotion x0) {
        return x0.project;
    }
}

