/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.Hudson;
import hudson.model.InvisibleAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamPassCondition
extends PromotionCondition {
    private final String jobs;
    private final boolean evenIfUnstable;

    public DownstreamPassCondition(String jobs) {
        this(jobs, false);
    }

    public DownstreamPassCondition(String jobs, boolean evenIfUnstable) {
        this.jobs = jobs;
        this.evenIfUnstable = evenIfUnstable;
    }

    public String getJobs() {
        return this.jobs;
    }

    public boolean isEvenIfUnstable() {
        return this.evenIfUnstable;
    }

    @Override
    public PromotionBadge isMet(AbstractBuild<?, ?> build) {
        Badge badge = new Badge();
        PseudoDownstreamBuilds pdb = (PseudoDownstreamBuilds)build.getAction(PseudoDownstreamBuilds.class);
        block0: for (AbstractProject<?, ?> j : this.getJobList()) {
            Result r;
            for (AbstractBuild abstractBuild : build.getDownstreamBuilds(j)) {
                r = abstractBuild.getResult();
                if (r != Result.SUCCESS && (!this.evenIfUnstable || r != Result.UNSTABLE)) continue;
                badge.add(abstractBuild);
                continue block0;
            }
            if (pdb != null) {
                for (AbstractBuild abstractBuild : pdb.listBuilds(j)) {
                    r = abstractBuild.getResult();
                    if (r != Result.SUCCESS && (!this.evenIfUnstable || r != Result.UNSTABLE)) continue;
                    badge.add(abstractBuild);
                    continue block0;
                }
            }
            return null;
        }
        return badge;
    }

    public List<AbstractProject<?, ?>> getJobList() {
        ArrayList r = new ArrayList();
        for (String name : Util.tokenize((String)this.jobs, (String)",")) {
            AbstractProject job = (AbstractProject)Hudson.getInstance().getItemByFullName(name.trim(), AbstractProject.class);
            if (job == null) continue;
            r.add(job);
        }
        return r;
    }

    public boolean contains(AbstractProject<?, ?> job) {
        if (!this.jobs.contains(job.getFullName())) {
            return false;
        }
        for (String name : Util.tokenize((String)this.jobs, (String)",")) {
            if (!name.trim().equals(job.getFullName())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PseudoDownstreamBuilds
    extends InvisibleAction {
        final List<Fingerprint.BuildPtr> builds = new ArrayList<Fingerprint.BuildPtr>();

        public void add(AbstractBuild<?, ?> run) {
            this.builds.add(new Fingerprint.BuildPtr(run));
        }

        public List<AbstractBuild<?, ?>> listBuilds(AbstractProject<?, ?> job) {
            ArrayList list = new ArrayList();
            for (Fingerprint.BuildPtr b : this.builds) {
                Run r;
                if (!b.is(job) || !((r = b.getRun()) instanceof AbstractBuild)) continue;
                list.add((AbstractBuild)r);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class RunListenerImpl
    extends RunListener<AbstractBuild<?, ?>> {
        private static volatile Set<AbstractProject> DOWNSTREAM_JOBS = Collections.emptySet();

        public RunListenerImpl() {
            super(AbstractBuild.class);
        }

        public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
            for (AbstractProject j : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                boolean warned = false;
                JobPropertyImpl jp = (JobPropertyImpl)j.getProperty(JobPropertyImpl.class);
                if (jp == null) continue;
                for (PromotionProcess p : jp.getItems()) {
                    boolean considerPromotion = false;
                    for (PromotionCondition cond : p.conditions) {
                        DownstreamPassCondition dpcond;
                        if (!(cond instanceof DownstreamPassCondition) || !(dpcond = (DownstreamPassCondition)cond).contains((AbstractProject)build.getParent())) continue;
                        considerPromotion = true;
                        break;
                    }
                    if (!considerPromotion) continue;
                    try {
                        AbstractBuild u = build.getUpstreamRelationshipBuild(j);
                        if (u == null) {
                            for (Cause.UpstreamCause uc : Util.filter((List)build.getCauses(), Cause.UpstreamCause.class)) {
                                if (!uc.getUpstreamProject().equals(j.getFullName()) || (u = (AbstractBuild)j.getBuildByNumber(uc.getUpstreamBuild())) == null) continue;
                                PseudoDownstreamBuilds pdb = (PseudoDownstreamBuilds)u.getAction(PseudoDownstreamBuilds.class);
                                if (pdb == null) {
                                    pdb = new PseudoDownstreamBuilds();
                                    u.addAction((Action)pdb);
                                }
                                pdb.add(build);
                                u.save();
                                break;
                            }
                        }
                        if (u == null && build.getResult() == Result.SUCCESS && !warned) {
                            listener.getLogger().println("WARNING: " + j.getFullDisplayName() + " appears to use this job as a promotion criteria, " + "but no fingerprint is recorded. Fingerprint needs to be enabled on both this job and " + j.getFullDisplayName() + ". " + "See http://hudson.gotdns.com/wiki/display/HUDSON/Fingerprint for more details");
                            warned = true;
                        }
                        if (u == null || !p.considerPromotion(u)) continue;
                        listener.getLogger().println("Promoted " + u);
                    }
                    catch (IOException e) {
                        e.printStackTrace(listener.error("Failed to promote a build"));
                    }
                }
            }
        }

        public static void rebuildCache() {
            DOWNSTREAM_JOBS = new HashSet<AbstractProject>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends PromotionConditionDescriptor {
        public static final DescriptorImpl INSTANCE = new DescriptorImpl();

        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "When the following downstream projects build successfully";
        }

        public String getHelpFile() {
            return "/plugin/promoted-builds/conditions/downstream.html";
        }

        public PromotionCondition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new DownstreamPassCondition(formData.getString("jobs"), formData.getBoolean("evenIfUnstable"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Badge
    extends PromotionBadge {
        public final List<Fingerprint.BuildPtr> builds = new ArrayList<Fingerprint.BuildPtr>();

        void add(AbstractBuild<?, ?> b) {
            this.builds.add(new Fingerprint.BuildPtr(b));
        }
    }
}

