/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.conditions.DownstreamPassCondition;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamPassCondition
extends PromotionCondition {
    private final String jobs;

    public DownstreamPassCondition(String jobs) {
        this.jobs = jobs;
    }

    public String getJobs() {
        return this.jobs;
    }

    public PromotionBadge isMet(AbstractBuild<?, ?> build) {
        Badge badge = new Badge();
        block0: for (AbstractProject j : this.getJobList()) {
            for (AbstractBuild b : build.getDownstreamBuilds(j)) {
                if (b.getResult() != Result.SUCCESS) continue;
                badge.add(b);
                continue block0;
            }
            return null;
        }
        return badge;
    }

    public PromotionConditionDescriptor getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    public List<AbstractProject<?, ?>> getJobList() {
        ArrayList r = new ArrayList();
        for (String name : Util.tokenize((String)this.jobs, (String)",")) {
            AbstractProject job = (AbstractProject)Hudson.getInstance().getItemByFullName(name.trim(), AbstractProject.class);
            if (job == null) continue;
            r.add(job);
        }
        return r;
    }

    public boolean contains(AbstractProject<?, ?> job) {
        if (!this.jobs.contains(job.getFullName())) {
            return false;
        }
        for (String name : Util.tokenize((String)this.jobs, (String)",")) {
            if (!name.trim().equals(job.getFullName())) continue;
            return true;
        }
        return false;
    }
}

