/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildBadgeAction;
import hudson.model.Cause;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.ManualPromotionBadge;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.Status;
import hudson.util.CopyOnWriteList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PromotedBuildAction
implements BuildBadgeAction {
    public final AbstractBuild<?, ?> owner;
    private final CopyOnWriteList<Status> statuses = new CopyOnWriteList();

    public PromotedBuildAction(AbstractBuild<?, ?> owner) {
        assert (owner != null);
        this.owner = owner;
    }

    public PromotedBuildAction(AbstractBuild<?, ?> owner, Status firstStatus) {
        this(owner);
        this.statuses.add((Object)firstStatus);
    }

    public AbstractProject<?, ?> getProject() {
        return this.owner.getProject();
    }

    public boolean contains(PromotionProcess process) {
        for (Status s : this.statuses) {
            if (!s.isFor(process)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name) {
        for (Status s : this.statuses) {
            if (!s.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean add(Status status) throws IOException {
        for (Status s : this.statuses) {
            if (!s.name.equals(status.name)) continue;
            return false;
        }
        this.statuses.add((Object)status);
        status.parent = this;
        this.owner.save();
        return true;
    }

    public List<Status> getPromotions() {
        return this.statuses.getView();
    }

    public Status getPromotion(String name) {
        for (Status s : this.statuses) {
            if (!s.name.equals(name)) continue;
            return s;
        }
        return null;
    }

    public boolean hasPromotion() {
        return !this.statuses.isEmpty();
    }

    public boolean canPromote() {
        return this.getProject().hasPermission(Promotion.PROMOTE);
    }

    public List<PromotionProcess> getPendingPromotions() {
        JobPropertyImpl pp = (JobPropertyImpl)this.getProject().getProperty(JobPropertyImpl.class);
        if (pp == null) {
            return Collections.emptyList();
        }
        ArrayList<PromotionProcess> r = new ArrayList<PromotionProcess>();
        for (PromotionProcess p : pp.getActiveItems()) {
            if (this.contains(p)) continue;
            r.add(p);
        }
        return r;
    }

    public String getIconFileName() {
        return "star.gif";
    }

    public String getDisplayName() {
        return "Promotion Status";
    }

    public String getUrlName() {
        return "promotion";
    }

    private Object readResolve() {
        for (Status s : this.statuses) {
            s.parent = this;
        }
        return this;
    }

    public Status getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        return this.getPromotion(name);
    }

    public void doForcePromotion(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="name") String name) throws IOException {
        if (!this.getProject().hasPermission(Promotion.PROMOTE)) {
            return;
        }
        JobPropertyImpl pp = (JobPropertyImpl)this.getProject().getProperty(JobPropertyImpl.class);
        if (pp == null) {
            throw new IllegalStateException("This project doesn't have any promotion criteria set");
        }
        PromotionProcess p = pp.getItem(name);
        if (p == null) {
            throw new IllegalStateException("This project doesn't have the promotion criterion called " + name);
        }
        p.promote(this.owner, (Cause)new Cause.UserCause(), new Status(p, Collections.singleton(new ManualPromotionBadge())));
        rsp.sendRedirect2(".");
    }
}

