/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds.conditions;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownstreamPassCondition
extends PromotionCondition {
    private final String jobs;

    public DownstreamPassCondition(String jobs) {
        this.jobs = jobs;
    }

    public String getJobs() {
        return this.jobs;
    }

    @Override
    public PromotionBadge isMet(AbstractBuild<?, ?> build) {
        Badge badge = new Badge();
        block0: for (AbstractProject<?, ?> j : this.getJobList()) {
            for (AbstractBuild b : build.getDownstreamBuilds(j)) {
                if (b.getResult() != Result.SUCCESS) continue;
                badge.add(b);
                continue block0;
            }
            return null;
        }
        return badge;
    }

    public List<AbstractProject<?, ?>> getJobList() {
        ArrayList r = new ArrayList();
        for (String name : Util.tokenize((String)this.jobs, (String)",")) {
            AbstractProject job = (AbstractProject)Hudson.getInstance().getItemByFullName(name.trim(), AbstractProject.class);
            if (job == null) continue;
            r.add(job);
        }
        return r;
    }

    public boolean contains(AbstractProject<?, ?> job) {
        if (!this.jobs.contains(job.getFullName())) {
            return false;
        }
        for (String name : Util.tokenize((String)this.jobs, (String)",")) {
            if (!name.trim().equals(job.getFullName())) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class RunListenerImpl
    extends RunListener<AbstractBuild<?, ?>> {
        private static volatile Set<AbstractProject> DOWNSTREAM_JOBS = Collections.emptySet();

        public RunListenerImpl() {
            super(AbstractBuild.class);
        }

        public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
            for (AbstractProject j : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                boolean warned = false;
                JobPropertyImpl jp = (JobPropertyImpl)j.getProperty(JobPropertyImpl.class);
                if (jp == null) continue;
                for (PromotionProcess p : jp.getItems()) {
                    boolean considerPromotion = false;
                    for (PromotionCondition cond : p.conditions) {
                        DownstreamPassCondition dpcond;
                        if (!(cond instanceof DownstreamPassCondition) || !(dpcond = (DownstreamPassCondition)cond).contains((AbstractProject)build.getParent())) continue;
                        considerPromotion = true;
                        break;
                    }
                    if (!considerPromotion) continue;
                    try {
                        AbstractBuild u = build.getUpstreamRelationshipBuild(j);
                        if (u == null) {
                            if (build.getResult() != Result.SUCCESS || warned) continue;
                            listener.getLogger().println("WARNING: " + j.getFullDisplayName() + " appears to use this job as a promotion criteria, " + "but no fingerprint is recorded. Fingerprint needs to be enabled on both this job and " + j.getFullDisplayName() + ". " + "See http://hudson.gotdns.com/wiki/display/HUDSON/Fingerprint for more details");
                            warned = true;
                            continue;
                        }
                        if (!p.considerPromotion(u)) continue;
                        listener.getLogger().println("Promoted " + u);
                    }
                    catch (IOException e) {
                        e.printStackTrace(listener.error("Failed to promote a build"));
                    }
                }
            }
        }

        public static void rebuildCache() {
            DOWNSTREAM_JOBS = new HashSet<AbstractProject>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends PromotionConditionDescriptor {
        public static final DescriptorImpl INSTANCE = new DescriptorImpl();

        @Override
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "When the following downstream projects build successfully";
        }

        public String getHelpFile() {
            return "/plugin/promoted-builds/conditions/downstream.html";
        }

        public PromotionCondition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new DownstreamPassCondition(formData.getString("jobs"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Badge
    extends PromotionBadge {
        public final List<Fingerprint.BuildPtr> builds = new ArrayList<Fingerprint.BuildPtr>();

        void add(AbstractBuild<?, ?> b) {
            this.builds.add(new Fingerprint.BuildPtr(b));
        }
    }
}

