/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.ItemGroupMixIn;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotedProjectAction;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.tasks.BuildStep;
import hudson.util.Function1;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JobPropertyImpl
extends JobProperty<AbstractProject<?, ?>>
implements ItemGroup<PromotionProcess> {
    private transient List<PromotionProcess> processes = new ArrayList<PromotionProcess>();
    private transient List<PromotionProcess> activeProcesses;
    private final Set<String> activeProcessNames = new HashSet<String>();

    public JobPropertyImpl(AbstractProject<?, ?> owner) throws Descriptor.FormException, IOException {
        this.owner = owner;
        this.init();
    }

    private JobPropertyImpl(StaplerRequest req, JSONObject json) throws Descriptor.FormException, IOException {
        List ancs = req.getAncestors();
        this.owner = (AbstractProject)((Ancestor)ancs.get(ancs.size() - 1)).getObject();
        if (json.has("promotions")) {
            json = json.getJSONObject("promotions");
        }
        for (JSONObject c : JSONArray.fromObject((Object)json.get("config"))) {
            PromotionProcess p;
            String name = c.getString("name");
            this.activeProcessNames.add(name);
            try {
                p = (PromotionProcess)Items.load((ItemGroup)this, (File)this.getRootDirFor(name));
            }
            catch (IOException e) {
                p = new PromotionProcess(this, name);
            }
            p.configure(req, c);
            this.processes.add(p);
        }
        this.init();
    }

    private void init() throws IOException {
        File[] subdirs = this.getRootDir().listFiles(new FileFilter(){

            public boolean accept(File child) {
                return child.isDirectory() && !JobPropertyImpl.this.activeProcessNames.contains(child.getName());
            }
        });
        if (subdirs != null) {
            for (File subdir : subdirs) {
                PromotionProcess p = (PromotionProcess)Items.load((ItemGroup)this, (File)subdir);
                this.processes.add(p);
            }
        }
        this.buildActiveProcess();
    }

    public PromotionProcess addProcess(String name) throws IOException {
        PromotionProcess p = new PromotionProcess(this, name);
        this.activeProcessNames.add(name);
        this.processes.add(p);
        this.buildActiveProcess();
        return p;
    }

    protected void setOwner(AbstractProject<?, ?> owner) {
        super.setOwner(owner);
        this.processes = new ArrayList(ItemGroupMixIn.loadChildren((ItemGroup)this, (File)this.getRootDir(), (Function1)ItemGroupMixIn.KEYED_BY_NAME).values());
        try {
            this.buildActiveProcess();
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private void buildActiveProcess() throws IOException {
        this.activeProcesses = new ArrayList<PromotionProcess>();
        Iterator<PromotionProcess> i$ = this.processes.iterator();
        while (i$.hasNext()) {
            PromotionProcess p;
            boolean active = this.activeProcessNames.contains((p = i$.next()).getName());
            p.makeDisabled(!active);
            if (!active) continue;
            this.activeProcesses.add(p);
        }
    }

    public List<PromotionProcess> getItems() {
        return this.processes;
    }

    public List<PromotionProcess> getActiveItems() {
        return this.activeProcesses;
    }

    public AbstractProject<?, ?> getOwner() {
        return (AbstractProject)this.owner;
    }

    public PromotionProcess getItem(String name) {
        for (PromotionProcess c : this.processes) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public File getRootDir() {
        return new File(this.getOwner().getRootDir(), "promotions");
    }

    public void save() throws IOException {
    }

    public String getUrl() {
        return this.getOwner().getUrl() + "promotion/";
    }

    public String getFullName() {
        return this.getOwner().getFullName() + "/promotion";
    }

    public String getFullDisplayName() {
        return this.getOwner().getFullDisplayName() + " \u00bb promotion";
    }

    public String getUrlChildPrefix() {
        return "";
    }

    public File getRootDirFor(PromotionProcess child) {
        return this.getRootDirFor(child.getName());
    }

    File getRootDirFor(String name) {
        return new File(this.getRootDir(), name);
    }

    public String getDisplayName() {
        return "promotion";
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        build.addAction((Action)new PromotedBuildAction(build));
        return true;
    }

    public Action getJobAction(AbstractProject<?, ?> job) {
        return new PromotedProjectAction(job, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public final Class<PromotionProcess> promotionProcessType = PromotionProcess.class;

        public String getDisplayName() {
            return "Promote Builds When...";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public JobPropertyImpl newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            try {
                if (json.has("promotions")) {
                    return new JobPropertyImpl(req, json);
                }
                return null;
            }
            catch (IOException e) {
                throw new Descriptor.FormException("Failed to create", (Throwable)e, null);
            }
        }

        public List<PromotionConditionDescriptor> getApplicableConditions(AbstractProject<?, ?> p) {
            return PromotionCondition.getApplicableTriggers(p);
        }

        public List<Descriptor<? extends BuildStep>> getApplicableBuildSteps(AbstractProject<?, ?> p) {
            return PromotionProcess.getAll();
        }
    }
}

