/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.plugins.promoted_builds.PromotionTargetAction;
import hudson.plugins.promoted_builds.Status;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepCompatibilityLayer;
import hudson.tasks.BuildTrigger;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Promotion
extends AbstractBuild<PromotionProcess, Promotion> {
    private int targetBuildNumber;
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(Promotion.class, null);
    public static final Permission PROMOTE = new Permission(PERMISSIONS, "Promote", null, Hudson.ADMINISTER);

    public Promotion(PromotionProcess job) throws IOException {
        super((AbstractProject)job);
    }

    public Promotion(PromotionProcess job, Calendar timestamp) {
        super((AbstractProject)job, timestamp);
    }

    public Promotion(PromotionProcess project, File buildDir) throws IOException {
        super((AbstractProject)project, buildDir);
    }

    public AbstractBuild<?, ?> getTarget() {
        return (AbstractBuild)((PromotionProcess)this.getParent()).getOwner().getBuildByNumber(this.targetBuildNumber);
    }

    public Status getStatus() {
        return ((PromotedBuildAction)this.getTarget().getAction(PromotedBuildAction.class)).getPromotion(((PromotionProcess)this.getParent()).getName());
    }

    public EnvVars getEnvironment(TaskListener listener) throws IOException, InterruptedException {
        EnvVars e = super.getEnvironment(listener);
        String rootUrl = Hudson.getInstance().getRootUrl();
        if (rootUrl != null) {
            e.put((Object)"PROMOTED_URL", (Object)(rootUrl + this.getTarget().getUrl()));
        }
        return e;
    }

    public void run() {
        this.run((Run.Runner)new RunnerImpl());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RunnerImpl
    extends AbstractBuild.AbstractRunner {
        protected RunnerImpl() {
            super((AbstractBuild)Promotion.this);
        }

        private AbstractBuild<?, ?> getTarget() {
            PromotionTargetAction pta = (PromotionTargetAction)Promotion.this.getAction(PromotionTargetAction.class);
            return pta.resolve();
        }

        protected WorkspaceList.Lease decideWorkspace(Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            return wsl.acquire(n.getWorkspaceFor((TopLevelItem)this.getTarget().getProject()), true);
        }

        protected Result doRun(BuildListener listener) throws Exception {
            AbstractBuild<?, ?> target = this.getTarget();
            Promotion.this.targetBuildNumber = target.getNumber();
            listener.getLogger().println("Promoting " + target);
            Promotion.this.getStatus().addPromotionAttempt(Promotion.this);
            Promotion.this.setResult(Result.SUCCESS);
            if (!this.preBuild(listener, ((PromotionProcess)Promotion.this.project).getBuildSteps())) {
                return Result.FAILURE;
            }
            if (!this.build(listener, ((PromotionProcess)Promotion.this.project).getBuildSteps())) {
                return Result.FAILURE;
            }
            return null;
        }

        protected void post2(BuildListener listener) throws Exception {
            if (Promotion.this.getResult() == Result.SUCCESS) {
                Promotion.this.getStatus().onSuccessfulPromotion(Promotion.this);
            }
            this.getTarget().save();
        }

        private boolean build(BuildListener listener, List<BuildStep> steps) throws IOException, InterruptedException {
            for (BuildStep bs : steps) {
                if (bs instanceof BuildTrigger) {
                    BuildTrigger bt = (BuildTrigger)bs;
                    for (AbstractProject p : bt.getChildProjects()) {
                        listener.getLogger().println("  scheduling build for " + p.getDisplayName());
                        p.scheduleBuild();
                    }
                    continue;
                }
                if (!bs.perform((AbstractBuild)Promotion.this, this.launcher, listener)) {
                    listener.getLogger().println("failed build " + bs + " " + Promotion.this.getResult());
                    return false;
                }
                listener.getLogger().println("build " + bs + " " + Promotion.this.getResult());
            }
            return true;
        }

        private boolean preBuild(BuildListener listener, List<BuildStep> steps) {
            boolean allOk = true;
            for (BuildStep bs : steps) {
                if (bs instanceof BuildStepCompatibilityLayer && !this.overridesPerform(bs.getClass())) {
                    listener.getLogger().println(bs + " doesn't support Promotion");
                    allOk = false;
                    continue;
                }
                if (bs.prebuild((AbstractBuild)Promotion.this, listener)) continue;
                listener.getLogger().println("failed pre build " + bs + " " + Promotion.this.getResult());
                return false;
            }
            return allOk;
        }

        private boolean overridesPerform(Class<? extends BuildStep> bsc) {
            try {
                Class<?> declarer = bsc.getMethod("perform", AbstractBuild.class, Launcher.class, BuildListener.class).getDeclaringClass();
                return !declarer.equals(BuildStepCompatibilityLayer.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
        }
    }
}

