/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.JDK;
import hudson.model.Label;
import hudson.model.Queue;
import hudson.model.Saveable;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionCondition;
import hudson.plugins.promoted_builds.PromotionConditionDescriptor;
import hudson.plugins.promoted_builds.PromotionTargetAction;
import hudson.plugins.promoted_builds.Status;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PromotionProcess
extends AbstractProject<PromotionProcess, Promotion>
implements Saveable {
    public final DescribableList<PromotionCondition, PromotionConditionDescriptor> conditions = new DescribableList((Saveable)this);
    private List<BuildStep> buildSteps = new ArrayList<BuildStep>();

    PromotionProcess(JobPropertyImpl property, String name) {
        super((ItemGroup)property, name);
    }

    void configure(StaplerRequest req, JSONObject c) throws Descriptor.FormException, IOException {
        this.conditions.rebuild(req, c, PromotionCondition.all());
        this.buildSteps = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)c, (String)"buildStep", PromotionProcess.getAll());
        this.save();
    }

    public AbstractProject getRootProject() {
        return this.getParent().getOwner().getRootProject();
    }

    public JobPropertyImpl getParent() {
        return (JobPropertyImpl)super.getParent();
    }

    public AbstractProject<?, ?> getOwner() {
        return this.getParent().getOwner();
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return new DescribableList((Saveable)this);
    }

    protected Class<Promotion> getBuildClass() {
        return Promotion.class;
    }

    public List<BuildStep> getBuildSteps() {
        return this.buildSteps;
    }

    public Label getAssignedLabel() {
        return this.getOwner().getAssignedLabel();
    }

    public JDK getJDK() {
        return this.getOwner().getJDK();
    }

    public Status isMet(AbstractBuild<?, ?> build) {
        ArrayList<PromotionBadge> badges = new ArrayList<PromotionBadge>();
        for (PromotionCondition cond : this.conditions) {
            PromotionBadge b = cond.isMet(build);
            if (b == null) {
                return null;
            }
            badges.add(b);
        }
        return new Status(this, badges);
    }

    public boolean considerPromotion(AbstractBuild<?, ?> build) throws IOException {
        PromotedBuildAction a = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
        if (a != null && a.contains(this)) {
            return false;
        }
        Status qualification = this.isMet(build);
        if (qualification == null) {
            return false;
        }
        this.promote(build, (Cause)new Cause.LegacyCodeCause(), qualification);
        return true;
    }

    public void promote(AbstractBuild<?, ?> build, Cause cause, Status qualification) throws IOException {
        PromotedBuildAction a = (PromotedBuildAction)build.getAction(PromotedBuildAction.class);
        if (a != null) {
            a.add(qualification);
        } else {
            build.addAction((Action)new PromotedBuildAction(build, qualification));
            build.save();
        }
        this.scheduleBuild(build, cause);
    }

    public boolean scheduleBuild() {
        return super.scheduleBuild();
    }

    public boolean scheduleBuild(AbstractBuild<?, ?> build) {
        return this.scheduleBuild(build, (Cause)new Cause.LegacyCodeCause());
    }

    public boolean scheduleBuild(AbstractBuild<?, ?> build, Cause cause) {
        assert (build.getProject() == this.getOwner());
        return super.scheduleBuild(0, cause, new Action[]{new PromotionTargetAction(build)});
    }

    public boolean isInQueue(AbstractBuild<?, ?> build) {
        for (Queue.Item item : Hudson.getInstance().getQueue().getItems((Queue.Task)this)) {
            if (((PromotionTargetAction)item.getAction(PromotionTargetAction.class)).resolve() != build) continue;
            return true;
        }
        return false;
    }

    public boolean isFingerprintConfigured() {
        throw new UnsupportedOperationException();
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        throw new UnsupportedOperationException();
    }

    public static List<Descriptor<? extends BuildStep>> getAll() {
        ArrayList<Descriptor<? extends BuildStep>> list = new ArrayList<Descriptor<? extends BuildStep>>();
        PromotionProcess.addTo((List<? extends Descriptor<? extends BuildStep>>)Builder.all(), list);
        PromotionProcess.addTo((List<? extends Descriptor<? extends BuildStep>>)Publisher.all(), list);
        return list;
    }

    private static void addTo(List<? extends Descriptor<? extends BuildStep>> source, List<Descriptor<? extends BuildStep>> list) {
        for (Descriptor<? extends BuildStep> descriptor : source) {
            BuildStepDescriptor bsd;
            if (!(descriptor instanceof BuildStepDescriptor) || !(bsd = (BuildStepDescriptor)descriptor).isApplicable(PromotionProcess.class)) continue;
            list.add(descriptor);
        }
    }
}

