/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.promoted_builds;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotedBuildAction;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionBadge;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.util.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Status {
    public final String name;
    private final PromotionBadge[] badges;
    public final Calendar timestamp = new GregorianCalendar();
    private int promotion = -1;
    private List<Integer> promotionAttempts = new ArrayList<Integer>();
    transient PromotedBuildAction parent;

    public Status(PromotionProcess process, Collection<? extends PromotionBadge> badges) {
        this.name = process.getName();
        this.badges = badges.toArray(new PromotionBadge[badges.size()]);
    }

    public String getName() {
        return this.name;
    }

    public PromotedBuildAction getParent() {
        return this.parent;
    }

    public PromotionProcess getProcess() {
        JobPropertyImpl jp = (JobPropertyImpl)this.parent.getProject().getProperty(JobPropertyImpl.class);
        if (jp == null) {
            return null;
        }
        return jp.getItem(this.name);
    }

    public AbstractBuild<?, ?> getTarget() {
        return this.getParent().owner;
    }

    public String getTimestampString() {
        long duration = new GregorianCalendar().getTimeInMillis() - this.timestamp.getTimeInMillis();
        return Util.getTimeSpanString((long)duration);
    }

    public String getDelayString(AbstractBuild<?, ?> owner) {
        long duration = this.timestamp.getTimeInMillis() - owner.getTimestamp().getTimeInMillis() - owner.getDuration();
        return Util.getTimeSpanString((long)duration);
    }

    public boolean isFor(PromotionProcess process) {
        return process.getName().equals(this.name);
    }

    public Promotion getSuccessfulPromotion(JobPropertyImpl jp) {
        PromotionProcess p;
        if (this.promotion >= 0 && (p = jp.getItem(this.name)) != null) {
            return (Promotion)p.getBuildByNumber(this.promotion);
        }
        return null;
    }

    public boolean isPromotionSuccessful() {
        return this.promotion >= 0;
    }

    public boolean isPromotionAttempted() {
        return !this.promotionAttempts.isEmpty();
    }

    public boolean isInQueue() {
        PromotionProcess p = this.getProcess();
        return p != null && p.isInQueue(this.getTarget());
    }

    public List<PromotionBadge> getBadges() {
        return Arrays.asList(this.badges);
    }

    void addPromotionAttempt(Promotion p) {
        this.promotionAttempts.add(p.getNumber());
    }

    void onSuccessfulPromotion(Promotion p) {
        this.promotion = p.getNumber();
    }

    public Promotion getLastSuccessful() {
        PromotionProcess p = this.getProcess();
        for (Integer n : Iterators.reverse(this.promotionAttempts)) {
            Promotion b = (Promotion)p.getBuildByNumber(n);
            if (b == null || b.getResult() != Result.SUCCESS) continue;
            return b;
        }
        return null;
    }

    public Promotion getLastFailed() {
        PromotionProcess p = this.getProcess();
        for (Integer n : Iterators.reverse(this.promotionAttempts)) {
            Promotion b = (Promotion)p.getBuildByNumber(n);
            if (b == null || b.getResult() == Result.SUCCESS) continue;
            return b;
        }
        return null;
    }

    public List<Promotion> getPromotionBuilds() {
        PromotionProcess p = this.getProcess();
        ArrayList<Promotion> builds = new ArrayList<Promotion>();
        for (Integer n : Iterators.reverse(this.promotionAttempts)) {
            Promotion b = (Promotion)p.getBuildByNumber(n);
            if (b == null) continue;
            builds.add(b);
        }
        return builds;
    }

    public void doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.getTarget().hasPermission(Promotion.PROMOTE)) {
            return;
        }
        this.getProcess().scheduleBuild(this.getTarget(), (Cause)new Cause.UserCause());
        rsp.forwardToPreviousPage(req);
    }
}

