/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pvcs_scm;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.pvcs_scm.PvcsChangeLogParser;
import hudson.plugins.pvcs_scm.PvcsLogReader;
import hudson.plugins.pvcs_scm.PvcsScm;
import hudson.plugins.pvcs_scm.changelog.ChangeLogDocument;
import hudson.plugins.pvcs_scm.changelog.PvcsChangeLogEntry;
import hudson.plugins.pvcs_scm.changelog.PvcsChangeLogSet;
import hudson.scm.SCM;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;

public class PvcsScm
extends SCM {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final String IN_DATE_FORMAT = "MM/dd/yyyy hh:mm:ss aa";
    private static final String OUT_DATE_FORMAT = "MMM dd yyyy HH:mm:ss";
    private String projectRoot;
    private String archiveRoot;
    private String changeLogPrefixFudge;
    private String moduleDir;
    private boolean cleanCopy;

    @DataBoundConstructor
    public PvcsScm(String projectRoot, String archiveRoot, String changeLogPrefixFudge, String moduleDir, boolean cleanCopy) {
        this.projectRoot = projectRoot;
        this.archiveRoot = archiveRoot;
        this.changeLogPrefixFudge = changeLogPrefixFudge;
        this.moduleDir = moduleDir;
        this.cleanCopy = cleanCopy;
        this.logger.debug((Object)"created new instance");
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public String getArchiveRoot() {
        return this.archiveRoot;
    }

    public void setArchiveRoot(String archiveRoot) {
        this.archiveRoot = archiveRoot;
    }

    public boolean isCleanCopy() {
        return this.cleanCopy;
    }

    public void setCleanCopy(boolean cleanCopy) {
        this.cleanCopy = cleanCopy;
    }

    public String getModuleDir() {
        return this.moduleDir;
    }

    public void setModuleDir(String moduleDir) {
        this.moduleDir = moduleDir;
    }

    public String getChangeLogPrefixFudge() {
        return this.changeLogPrefixFudge;
    }

    public void setChangeLogPrefixFudge(String changeLogPrefixFudge) {
        this.changeLogPrefixFudge = changeLogPrefixFudge;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath workspace, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        this.logger.trace((Object)"in checkout()");
        boolean checkoutSucceeded = true;
        ChangeLogDocument doc = ChangeLogDocument.Factory.newInstance();
        Run previousBuild = build.getPreviousBuild();
        if (previousBuild != null) {
            doc.setChangeLog(this.getModifications(launcher, (TaskListener)listener, previousBuild.getTimestamp()));
            doc.getChangeLog().setLastBuildId(previousBuild.getId());
            doc.getChangeLog().setLastBuildTime(previousBuild.getTimestamp());
        } else {
            doc.addNewChangeLog();
        }
        doc.getChangeLog().setBuildId(build.getId());
        doc.save(changelogFile);
        if (this.cleanCopy) {
            listener.getLogger().println("clean copy configured; deleting contents of " + workspace);
            this.logger.info((Object)("deleting contents of workspace " + workspace));
            workspace.deleteContents();
        }
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(this.getDescriptor().getExecutable());
        cmd.add(new String[]{"-nb", "run", "-ns", "-y"});
        cmd.add("get");
        cmd.add("-pr" + this.projectRoot);
        cmd.add("-bp/");
        cmd.add("-o");
        cmd.add("-a.");
        cmd.add("-z");
        cmd.add(this.moduleDir);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.logger.debug((Object)("launching command " + cmd.toList()));
        Proc proc = launcher.launch(cmd.toCommandArray(), new String[0], (OutputStream)baos, workspace);
        int rc = proc.join();
        if (rc != 0) {
            this.logger.error((Object)("command exited with " + rc));
            listener.error("command exited with " + rc);
            listener.error("continuing anyway.  @todo: filter results from PVCS");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("pcli output:\n" + new String(baos.toByteArray())));
        }
        listener.getLogger().println("pcli output:");
        listener.getLogger().write(baos.toByteArray(), 0, baos.size());
        return checkoutSucceeded;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        this.logger.debug((Object)("polling for changes in " + workspace));
        boolean changeDetected = true;
        if (project.getLastBuild() == null) {
            this.logger.info((Object)"no existing build; starting a new one");
            listener.getLogger().println("no existing build; starting a new one");
        } else {
            PvcsChangeLogSet changeSet = this.getModifications(launcher, listener, project.getLastBuild().getTimestamp());
            boolean bl = changeDetected = changeSet.sizeOfEntryArray() > 0;
            if (!changeDetected) {
                listener.getLogger().println("no changes detected");
            } else {
                for (PvcsChangeLogEntry entry : changeSet.getEntryArray()) {
                    listener.getLogger().print("==> " + entry.getFileName() + " ");
                    listener.getLogger().print(entry.getRevision() + " ");
                    listener.getLogger().print(entry.getModifiedTime().getTime() + " ");
                    listener.getLogger().println(entry.getModifiedTime().getTime());
                    listener.getLogger().println(entry.getComment());
                }
            }
        }
        return changeDetected;
    }

    public PvcsChangeLogSet getModifications(Launcher launcher, TaskListener listener, Calendar lastBuild) throws IOException, InterruptedException {
        Calendar now = Calendar.getInstance();
        this.logger.info((Object)("looking for changes between " + lastBuild.getTime() + " and " + now.getTime()));
        listener.getLogger().println("looking for changes between " + lastBuild.getTime() + " and " + now.getTime());
        SimpleDateFormat df = new SimpleDateFormat(IN_DATE_FORMAT);
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(this.getDescriptor().getExecutable());
        cmd.add(new String[]{"-nb", "run", "-ns", "-q"});
        cmd.add("vlog");
        cmd.add("-pr" + this.projectRoot);
        cmd.add("-i");
        cmd.add("-ds" + df.format(lastBuild.getTime()));
        cmd.add("-de" + df.format(now.getTime()));
        cmd.add("-z");
        cmd.add(this.moduleDir);
        PipedOutputStream os = new PipedOutputStream();
        PvcsLogReader logReader = new PvcsLogReader((InputStream)new PipedInputStream(os), this.archiveRoot, this.changeLogPrefixFudge, lastBuild.getTime());
        this.logger.debug((Object)("launching command " + cmd.toList()));
        Proc proc = launcher.launch(cmd.toCommandArray(), new String[0], null, (OutputStream)os);
        Thread t = new Thread((Runnable)logReader);
        t.start();
        int rc = proc.join();
        os.close();
        t.join();
        if (rc != 0) {
            this.logger.error((Object)("command failed, returned " + rc));
            listener.error("command failed, returned " + rc);
        }
        return logReader.getChangeLogSet();
    }

    public PvcsChangeLogParser createChangeLogParser() {
        return new PvcsChangeLogParser();
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }
}

