/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.pvcs_scm;

import hudson.plugins.pvcs_scm.changelog.PvcsChangeLogEntry;
import hudson.plugins.pvcs_scm.changelog.PvcsChangeLogSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PvcsLogReader
implements Runnable {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String lineSep = System.getProperty("line.separator");
    private final SimpleDateFormat outDateFormat = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
    private final SimpleDateFormat outDateFormatSub = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    private BufferedReader reader;
    private String archiveRoot;
    private String pathPrefix;
    private String archiveFileSuffix = "_v";
    private Date lastBuild;
    private boolean firstRev = true;
    private boolean firstModifiedTime = true;
    private boolean firstUserName = true;
    private boolean nextLineIsComment = false;
    private boolean waitingForNextValidStart = false;
    private PvcsChangeLogSet changeLogSet;
    private PvcsChangeLogEntry modification;

    public PvcsLogReader(InputStream is, String archiveRoot, String pathPrefix, Date lastBuild) {
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.archiveRoot = archiveRoot;
        this.pathPrefix = pathPrefix;
        this.lastBuild = lastBuild;
        this.changeLogSet = PvcsChangeLogSet.Factory.newInstance();
    }

    public PvcsChangeLogSet getChangeLogSet() {
        return this.changeLogSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String s = this.reader.readLine();
            while (s != null) {
                this.consumeLine(s);
                s = this.reader.readLine();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {}
        }
    }

    private void consumeLine(String line) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("line: " + line));
        }
        if (line.startsWith("Archive:")) {
            String fileName;
            if (this.modification != null & !this.waitingForNextValidStart) {
                this.logger.warn((Object)("discarding incomplete change log\n" + this.modification));
                this.changeLogSet.removeEntry(this.changeLogSet.sizeOfEntryArray() - 1);
            }
            this.modification = this.changeLogSet.addNewEntry();
            this.firstModifiedTime = true;
            this.firstUserName = true;
            this.firstRev = true;
            this.nextLineIsComment = false;
            this.waitingForNextValidStart = false;
            int startIndex = line.indexOf(this.archiveRoot);
            startIndex = startIndex != -1 ? (startIndex += this.archiveRoot.length()) : 0;
            int endIndex = line.indexOf(this.archiveFileSuffix);
            if (endIndex == -1) {
                endIndex = line.length();
            }
            if ((fileName = line.substring(startIndex, endIndex)).startsWith("/") || fileName.startsWith("\\")) {
                fileName = fileName.substring(1);
            }
            if (this.pathPrefix != null) {
                fileName = this.pathPrefix + fileName;
            }
            this.modification.setFileName(fileName);
        } else if (!this.waitingForNextValidStart) {
            if (line.startsWith("Rev") && !line.startsWith("Rev count")) {
                if (this.firstRev) {
                    this.firstRev = false;
                    this.modification.setRevision(line.substring(4));
                }
            } else if (line.startsWith("Checked in:")) {
                if (this.firstModifiedTime) {
                    this.firstModifiedTime = false;
                    String lastMod = line.substring(16);
                    Date modDate = null;
                    try {
                        modDate = this.outDateFormat.parse(lastMod);
                    }
                    catch (ParseException e) {
                        this.logger.debug((Object)String.format("Unable to parse modification time %s with %s", lastMod, this.outDateFormat.toPattern()));
                        try {
                            modDate = this.outDateFormatSub.parse(lastMod);
                        }
                        catch (ParseException pe) {
                            this.logger.error((Object)("Error parsing modification time " + lastMod + ": "), (Throwable)e);
                        }
                    }
                    Calendar modCal = Calendar.getInstance();
                    modCal.setTime(modDate);
                    this.modification.setModifiedTime(modCal);
                }
            } else if (this.nextLineIsComment) {
                boolean isEndOfCommentsLine;
                boolean isDashesLine = line.equals("-----------------------------------");
                boolean isEqualsLine = line.equals("===================================");
                boolean bl = isEndOfCommentsLine = isDashesLine || isEqualsLine;
                if (this.modification.getComment() == null || this.modification.getComment().length() == 0) {
                    this.modification.setComment(line);
                } else if (!isEndOfCommentsLine) {
                    this.modification.setComment(this.modification.getComment() + this.lineSep + line);
                } else {
                    this.waitingForNextValidStart = true;
                }
            } else if (line.startsWith("Author id:") && this.firstUserName) {
                StringTokenizer st = new StringTokenizer(line.substring(11), " ");
                this.modification.setUserName(st.nextToken().trim());
                this.firstUserName = false;
                this.nextLineIsComment = true;
            }
        }
    }
}

